/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.gui;

import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.gui.builders.DefaultFormBuilder;
import net.sourceforge.squirrel_sql.client.gui.controls.ColumnsComboBox;
import net.sourceforge.squirrel_sql.client.gui.controls.DataTypesComboBox;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.sql.DataTypeInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.gui.AlterTablePanelBuilder;

class AlterColumnsPanelBuilder {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AlterTablePanelBuilder.class);
    private Map<String, DataTypeInfo> _dataTypesByTypeName;
    private ControlMediator _mediator;
    private ColumnsComboBox _columnsCmb;
    private DataTypesComboBox _dataTypesCmb;
    private IntegerField _columnLengthField;
    private JTextField _defaultvalue;
    private JCheckBox _allowNullChk;
    private JCheckBox _autoIncChk;
    private JCheckBox _unsignedChk;
    private JCheckBox _binaryChk;
    private JCheckBox _zeroFillChk;

    AlterColumnsPanelBuilder() {
    }

    public JPanel buildPanel(ISession session, ITableInfo ti) throws SQLException {
        this.initComponents(session, ti);
        FormLayout layout = new FormLayout("12dlu, left:max(40dlu;pref), 3dlu, 75dlu:grow(0.50), 7dlu, 75dlu:grow(0.50), 3dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setLeadingColumnOffset(1);
        builder.appendSeparator(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.selectcolumn"));
        builder.append(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.columnname"), (Component)this._columnsCmb, 3);
        builder.appendSeparator(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.attributes"));
        builder.append(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.datatype"), (Component)this._dataTypesCmb, 3);
        builder.nextLine();
        builder.append(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.length"), (Component)this._columnLengthField, 3);
        builder.nextLine();
        builder.append(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.default"), (Component)this._defaultvalue, 3);
        builder.nextLine();
        builder.setLeadingColumnOffset(3);
        builder.append((Component)this._unsignedChk);
        builder.append((Component)this._autoIncChk);
        builder.nextLine();
        builder.append((Component)this._binaryChk);
        builder.append((Component)this._zeroFillChk);
        builder.nextLine();
        builder.append((Component)this._allowNullChk);
        builder.setLeadingColumnOffset(1);
        return builder.getPanel();
    }

    private static String getString(String stringMgrKey) {
        return s_stringMgr.getString(stringMgrKey);
    }

    private void updateControlStatus() {
        TableColumnInfo tci = this._columnsCmb.getSelectedColumn();
        this._dataTypesCmb.setSelectedItem((Object)this._dataTypesByTypeName.get(tci.getTypeName().toUpperCase()));
        this._columnLengthField.setInt(tci.getColumnSize());
        this._defaultvalue.setText(tci.getDefaultValue());
    }

    private void initComponents(ISession session, ITableInfo ti) throws SQLException {
        this._dataTypesByTypeName = new HashMap<String, DataTypeInfo>();
        this._mediator = new ControlMediator();
        ISQLConnection conn = session.getSQLConnection();
        this._columnsCmb = new ColumnsComboBox(conn, ti);
        this._dataTypesCmb = new DataTypesComboBox(conn);
        int limit = this._dataTypesCmb.getItemCount();
        for (int i = 0; i < limit; ++i) {
            DataTypeInfo dti = this._dataTypesCmb.getDataTypeAt(i);
            this._dataTypesByTypeName.put(dti.getSimpleName().toUpperCase(), dti);
        }
        this._columnLengthField = new IntegerField();
        this._defaultvalue = new JTextField();
        this._allowNullChk = new JCheckBox(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.allownull"));
        this._unsignedChk = new JCheckBox(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.unsigned"));
        this._autoIncChk = new JCheckBox(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.autoinc"));
        this._binaryChk = new JCheckBox(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.binary"));
        this._zeroFillChk = new JCheckBox(AlterColumnsPanelBuilder.getString("AlterColumnsPanelBuilder.zerofill"));
        this._columnsCmb.addActionListener((ActionListener)this._mediator);
        this.updateControlStatus();
    }

    private final class ControlMediator
    implements ActionListener {
        private ControlMediator() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AlterColumnsPanelBuilder.this.updateControlStatus();
        }
    }
}

