/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;

public class A_Sum
extends Aggregate_Function {
    private static final long serialVersionUID = 1L;
    protected double currentTotalDouble;
    protected long currentTotalInt;
    protected boolean hasData = false;
    protected boolean isIntType;
    protected BigDecimal totalDecimal;
    protected boolean isBigDecimal;

    public A_Sum(Expression expression) {
        this.children = new ArrayList(1);
        this.children.add(expression);
        this.computedExpr = expression;
        this.returnType = expression.getReturnType();
        this.isIntType = this.returnType == -5 || this.returnType == 4;
        this.isBigDecimal = false;
        this.totalDecimal = new BigDecimal(0);
    }

    @Override
    public void reset() {
        this.currentTotalDouble = 0.0;
        this.currentTotalInt = 0L;
        this.totalDecimal = new BigDecimal(0);
        this.hasData = false;
    }

    @Override
    public Object compute() {
        if (this.hasData) {
            if (this.isIntType) {
                return new Long(this.currentTotalInt);
            }
            if (this.isBigDecimal) {
                return new BigDecimal(this.totalDecimal.toString());
            }
            return new Double(this.currentTotalDouble);
        }
        return null;
    }

    @Override
    public void add(Tuple tuple) throws SQLException {
        Object object = this.computedExpr.evaluate(tuple);
        if (object != null) {
            if (this.isIntType) {
                this.currentTotalInt += ((Number)object).longValue();
            } else if (object instanceof String || object instanceof BigDecimal) {
                this.totalDecimal = this.totalDecimal.add(new BigDecimal(object.toString()));
                this.isBigDecimal = true;
            } else {
                this.currentTotalDouble += ((Number)object).doubleValue();
            }
            this.hasData = true;
        }
    }

    @Override
    public String toString(Relation relation, Attribute attribute) {
        return "SUM(" + this.computedExpr.toString(relation) + ") AS " + attribute.getName();
    }
}

