/*
 * Decompiled with CFR 0.152.
 */
package unity.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import unity.annotation.CommonMethods;
import unity.mapping.TypeInfo;

public class Database {
    private int databaseId;
    private String vendorName;
    private String productName;
    private int majorVersion;
    private int minorVersion;
    private int buildVersion;
    private String description;
    private String releaseDate;
    private ArrayList<String> systemSchemas;
    private int parentDialect;
    private HashMap<Integer, TypeInfo> types = new HashMap();

    public int getDatabaseId() {
        return this.databaseId;
    }

    public void importXML(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            Object object2;
            String string = node2.getNodeName();
            if (string.equals("Id")) {
                this.databaseId = CommonMethods.getIntName(node2);
                continue;
            }
            if (string.equals("Name")) {
                this.productName = CommonMethods.getName(node2);
                continue;
            }
            if (string.equals("ReleaseDate")) {
                this.releaseDate = CommonMethods.getName(node2);
                continue;
            }
            if (string.equals("InheritedDialectId")) {
                this.parentDialect = CommonMethods.getIntName(node2);
                continue;
            }
            if (string.equals("Desc")) {
                this.description = CommonMethods.getName(node2);
                continue;
            }
            if (string.equals("SystemSchemas")) {
                object2 = CommonMethods.getName(node2);
                this.systemSchemas = new ArrayList(2);
                object = new StringTokenizer((String)object2, ";");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.systemSchemas.add(((StringTokenizer)object).nextToken());
                }
                continue;
            }
            if (!string.equals("DBTypes")) continue;
            for (object2 = node2.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                if (!object2.getNodeName().equals("DBType")) continue;
                object = new TypeInfo();
                ((TypeInfo)object).importXML((Node)object2);
                this.types.put(((TypeInfo)object).getUnityId(), (TypeInfo)object);
            }
        }
    }

    public int getParentDialect() {
        return this.parentDialect;
    }

    public void setParentDialect(int n) {
        this.parentDialect = n;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String string) {
        this.productName = string;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public int getBuildVersion() {
        return this.buildVersion;
    }

    public void setBuildVersion(int n) {
        this.buildVersion = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String string) {
        this.releaseDate = string;
    }

    public void setDatabaseId(int n) {
        this.databaseId = n;
    }

    public ArrayList<String> getSystemSchemas() {
        return this.systemSchemas;
    }

    public void setSystemSchemas(ArrayList<String> arrayList) {
        this.systemSchemas = arrayList;
    }

    public boolean isSystemSchema(String string) {
        if (this.systemSchemas == null) {
            return false;
        }
        return this.systemSchemas.contains(string);
    }

    public TypeInfo getType(int n) {
        return this.types.get(n);
    }
}

