/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.operators.Operator;

public class TextFileScan
extends Operator {
    private static final long serialVersionUID = 1L;
    protected String inFileName;
    protected BufferedReader inFile;
    protected Relation inputRelation;

    public TextFileScan(String string, Relation relation) {
        this.inFileName = string;
        this.inputRelation = relation;
        this.setOutputRelation(relation);
    }

    @Override
    public void init() throws SQLException {
        try {
            this.inFile = FileManager.openTextInputFile(this.inFileName);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        try {
            tuple.readText(this.inFile);
            this.incrementRowsOut();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        try {
            FileManager.closeFile(this.inFile);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("TEXT FILE SCAN: (FileName=" + this.inFileName + ")");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "TEXT FILE SCAN";
    }

    @Override
    public String getDescription() {
        return "";
    }
}

