/*
 * Decompiled with CFR 0.152.
 */
package unity.parser;

import unity.parser.Node;
import unity.parser.uql;
import unity.parser.uqlTreeConstants;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected uql parser;
    protected Object reference;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(uql uql2, int n) {
        this(n);
        this.parser = uql2;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return uqlTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public void InsertChild(int n, Node node) {
        int n2;
        if (this.children.length < n) {
            return;
        }
        Node[] nodeArray = new Node[this.children.length + 1];
        for (n2 = 0; n2 < n; ++n2) {
            nodeArray[n2] = this.children[n2];
        }
        nodeArray[n2] = node;
        while (n2 < this.children.length) {
            nodeArray[n2 + 1] = this.children[n2];
            ++n2;
        }
        this.children = nodeArray;
    }

    public SimpleNode jjtRemoveChild(int n) {
        int n2 = 0;
        if (this.children == null) {
            return null;
        }
        if (this.children.length <= n) {
            return null;
        }
        SimpleNode simpleNode = (SimpleNode)this.children[n];
        Node[] nodeArray = new Node[this.children.length - 1];
        for (int i = 0; i < this.children.length; ++i) {
            if (i == n) continue;
            nodeArray[n2++] = this.children[i];
        }
        this.children = nodeArray;
        return simpleNode;
    }

    public int findChild(Node node) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != node) continue;
            return i;
        }
        return -1;
    }

    public void replaceChild(Node node, Node node2) {
        int n = this.findChild(node);
        if (n == -1) {
            return;
        }
        this.children[n] = node2;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object object) {
        this.reference = object;
    }
}

