/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dataimport.EDTMessageBoxUtil;
import net.sourceforge.squirrel_sql.plugins.dataimport.ImportFileType;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ImportFileDialogCtrl;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.FileImporterFactory;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;

public class ImportTableDataCommand
implements ICommand {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ImportTableDataCommand.class);
    private static final ILogger s_log = LoggerController.createLogger(ImportTableDataCommand.class);
    private static final String PREFS_KEY_LAST_IMPORT_DIRECTORY = "squirrelsql_dataimport_last_import_directory";
    private ISession session;
    private ITableInfo table;

    public ImportTableDataCommand(ISession session, ITableInfo table) {
        this.session = session;
        this.table = table;
    }

    public void execute() {
        JFileChooser openFile = new JFileChooser(Props.getString((String)PREFS_KEY_LAST_IMPORT_DIRECTORY, (String)System.getProperty("user.home")));
        int res = openFile.showOpenDialog((Component)this.session.getApplication().getMainFrame());
        if (res == 0) {
            File importFile = openFile.getSelectedFile();
            if (null != importFile.getParent()) {
                Props.putString((String)PREFS_KEY_LAST_IMPORT_DIRECTORY, (String)importFile.getParent());
            }
            try {
                TableColumnInfo[] columns = this.session.getMetaData().getColumnInfo(this.table);
                ImportFileType type = this.determineType(importFile);
                IFileImporter importer = FileImporterFactory.createImporter(type, importFile);
                if (importer.getConfigurationPanel() != null) {
                    JDialog dialog = new JDialog((Frame)this.session.getApplication().getMainFrame(), stringMgr.getString("ImportTableDataCommand.settingsDialogTitle"), true);
                    StateListener dialogState = new StateListener(dialog);
                    dialog.setLayout(new BorderLayout());
                    dialog.add((Component)importer.getConfigurationPanel(), "Center");
                    OkClosePanel buttons = new OkClosePanel();
                    buttons.getCloseButton().setText(stringMgr.getString("ImportTableDataCommand.cancel"));
                    buttons.addListener((IOkClosePanelListener)dialogState);
                    dialog.add((Component)buttons, "South");
                    dialog.pack();
                    GUIUtils.centerWithinParent((Window)dialog);
                    dialog.setVisible(true);
                    if (!dialogState.isOkPressed()) {
                        return;
                    }
                }
                ImportFileDialogCtrl importFileDialogCtrl = new ImportFileDialogCtrl(this.session, importFile, importer, this.table, columns);
                importFileDialogCtrl.setPreviewData(importer.getPreview(10));
                importFileDialogCtrl.show();
            }
            catch (SQLException e) {
                s_log.error((Object)("execute: unexpected exception - " + e.getMessage()), (Throwable)e);
                EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportTableDataCommand.sqlErrorOccured"), stringMgr.getString("ImportTableDataCommand.error"));
            }
            catch (IOException e) {
                s_log.error((Object)("execute: unexpected exception - " + e.getMessage()), (Throwable)e);
                EDTMessageBoxUtil.showMessageDialogOnEDT(stringMgr.getString("ImportTableDataCommand.ioErrorOccured"), stringMgr.getString("ImportTableDataCommand.error"));
            }
        }
    }

    private ImportFileType determineType(File f) {
        if (f.getName().toLowerCase().endsWith("xls") || f.getName().toLowerCase().endsWith("xlsx")) {
            return ImportFileType.XLS;
        }
        return ImportFileType.CSV;
    }

    private class StateListener
    implements IOkClosePanelListener {
        private boolean okPressed = false;
        private JDialog dialog = null;

        public StateListener(JDialog dialog) {
            this.dialog = dialog;
        }

        public void cancelPressed(OkClosePanelEvent evt) {
        }

        public void closePressed(OkClosePanelEvent evt) {
            this.okPressed = false;
            this.dialog.dispose();
        }

        public void okPressed(OkClosePanelEvent evt) {
            this.okPressed = true;
            this.dialog.dispose();
        }

        public boolean isOkPressed() {
            return this.okPressed;
        }
    }
}

