/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.codecompletion.prefs;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.ConfigCboItem;
import net.sourceforge.squirrel_sql.plugins.codecompletion.prefs.PrefixedConfig;

public class PrefixesTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<PrefixedConfig> _data = new ArrayList();

    public PrefixesTableModel(PrefixedConfig[] prefixedConfigs) {
        this._data.addAll(Arrays.asList(prefixedConfigs));
    }

    @Override
    public Object getValueAt(int row, int column) {
        PrefixedConfig buf = this._data.get(row);
        if (0 == column) {
            return buf.getPrefix();
        }
        return ConfigCboItem.getItemForConfig(buf.getCompletionConfig());
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        PrefixedConfig buf = this._data.get(row);
        if (0 == column) {
            buf.setPrefix(null == aValue ? "" : aValue.toString());
        } else {
            buf.setCompletionConfig(((ConfigCboItem)aValue).getCompletionConfig());
        }
        this.fireTableCellUpdated(row, column);
    }

    public void addNewConfig() {
        this._data.add(new PrefixedConfig());
        this.fireTableRowsInserted(this._data.size() - 1, this._data.size() - 1);
    }

    @Override
    public int getRowCount() {
        if (null == this._data) {
            return 0;
        }
        return this._data.size();
    }

    public void removeRows(int[] selRows) {
        int i;
        ArrayList<PrefixedConfig> toRemove = new ArrayList<PrefixedConfig>(selRows.length);
        for (i = 0; i < selRows.length; ++i) {
            toRemove.add(this._data.get(selRows[i]));
        }
        this._data.removeAll(toRemove);
        for (i = 0; i < selRows.length; ++i) {
            this.fireTableRowsDeleted(selRows[i], selRows[i]);
        }
    }

    public PrefixedConfig[] getData() {
        return this._data.toArray(new PrefixedConfig[this._data.size()]);
    }
}

