/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.smarttools;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.ISmarttoolFrame;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.SmarttoolChangeValuesFrame;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.SmarttoolFindBadNullValuesFrame;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.SmarttoolMissingIndicesFrame;

public class SmarttoolsPlugin
extends DefaultSessionPlugin {
    private static final ILogger log = LoggerController.createLogger(SmarttoolsPlugin.class);
    private static final StringManager stringManager = StringManagerFactory.getStringManager(SmarttoolsPlugin.class);
    private final int ST_SHEET_TYPE_FIND_VALUES = 1;
    private final int ST_SHEET_TYPE_CHANGE_VALUES = 2;
    private final int ST_SHEET_TYPE_MISSING_INICES = 3;

    public String getAuthor() {
        return "Michael Romankiewicz";
    }

    public String getDescriptiveName() {
        return "Smarttools Plugin";
    }

    public String getInternalName() {
        return "smarttools";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
    }

    public void unload() {
        super.unload();
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        try {
            IObjectTreeAPI objectTreeApi = session.getSessionInternalFrame().getObjectTreeAPI();
            objectTreeApi.addToPopup(DatabaseObjectType.SESSION, this.getSmarttoolsMenu(this.getApplication(), session, true));
            return new PluginSessionCallback(){

                public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                }

                public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                }

                public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JMenu getSmarttoolsMenu(IApplication application, ISession session, boolean forPopupMenu) {
        JMenu menu = new JMenu(i18n.MENU_TITLE_SMARTTOOLS);
        if (forPopupMenu) {
            menu.add(this.addMenuItem(application, i18n.MENU_TITLE_SMARTTOOLS_FIND_VALUES, 1, session));
            menu.add(this.addMenuItem(application, i18n.MENU_TITLE_SMARTTOOLS_CHANGE_VALUES, 2, session));
            menu.add(this.addMenuItem(application, i18n.MENU_TITLE_SMARTTOOLS_MISSING_INDICES, 3, session));
        }
        return menu;
    }

    private JMenuItem addMenuItem(final IApplication application, final String title, final int sheetType, final ISession session) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWidget frame = (DialogWidget)SmarttoolsPlugin.this.isInternalFrameUsed(application, sheetType);
                if (frame == null) {
                    if (sheetType == 1) {
                        frame = new SmarttoolFindBadNullValuesFrame(session, title);
                    } else if (sheetType == 2) {
                        frame = new SmarttoolChangeValuesFrame(session, title);
                    } else if (sheetType == 3) {
                        frame = new SmarttoolMissingIndicesFrame(session, title);
                    }
                    application.getMainFrame().addWidget(frame);
                    frame.pack();
                    if (frame instanceof SmarttoolFindBadNullValuesFrame) {
                        frame.setSize(new Dimension(frame.getWidth(), 500));
                    } else if (frame instanceof SmarttoolChangeValuesFrame) {
                        frame.setSize(new Dimension(frame.getWidth(), 500));
                    } else if (frame instanceof SmarttoolMissingIndicesFrame) {
                        frame.setSize(new Dimension(frame.getWidth(), 500));
                    }
                    DialogWidget.centerWithinDesktop((DialogWidget)frame);
                } else {
                    frame.setVisible(true);
                    frame.moveToFront();
                }
                try {
                    frame.setSelected(true);
                    if (frame instanceof ISmarttoolFrame) {
                        ((ISmarttoolFrame)frame).setFocusToFirstEmptyInputField();
                    }
                }
                catch (PropertyVetoException e) {
                    log.error((Object)e.getLocalizedMessage());
                }
            }
        });
        return menuItem;
    }

    private IWidget isInternalFrameUsed(IApplication application, int sheetType) {
        IWidget[] frames = application.getMainFrame().getDesktopContainer().getAllWidgets();
        for (int i = 0; i < frames.length; ++i) {
            if (!(sheetType == 1 && frames[i] instanceof SmarttoolFindBadNullValuesFrame || sheetType == 2 && frames[i] instanceof SmarttoolChangeValuesFrame) && (sheetType != 3 || !(frames[i] instanceof SmarttoolMissingIndicesFrame))) continue;
            return frames[i];
        }
        return null;
    }

    public void sessionEnding(ISession session) {
        super.sessionEnding(session);
        IWidget[] frames = session.getApplication().getMainFrame().getDesktopContainer().getAllWidgets();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof SmarttoolFindBadNullValuesFrame) && !(frames[i] instanceof SmarttoolChangeValuesFrame) && !(frames[i] instanceof SmarttoolMissingIndicesFrame)) continue;
            frames[i].dispose();
        }
    }

    static /* synthetic */ StringManager access$000() {
        return stringManager;
    }

    private static interface i18n {
        public static final String MENU_TITLE_SMARTTOOLS = SmarttoolsPlugin.access$000().getString("smarttools.menu.title");
        public static final String MENU_TITLE_SMARTTOOLS_FIND_VALUES = SmarttoolsPlugin.access$000().getString("smarttools.menu.findvalues.title");
        public static final String MENU_TITLE_SMARTTOOLS_CHANGE_VALUES = SmarttoolsPlugin.access$000().getString("smarttools.menu.changevalues.title");
        public static final String MENU_TITLE_SMARTTOOLS_MISSING_INDICES = SmarttoolsPlugin.access$000().getString("smarttools.menu.missingindices.title");
    }
}

