/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.vertica;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.vertica.VerticaObjectType;
import net.sourceforge.squirrel_sql.plugins.vertica.exp.ProjectionParentExpander;
import net.sourceforge.squirrel_sql.plugins.vertica.exp.SequenceExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.vertica.exp.SysTableExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.vertica.exp.TableExpander;
import net.sourceforge.squirrel_sql.plugins.vertica.exp.UDFExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.vertica.exp.UDTExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.vertica.tab.ContentPlusTab;
import net.sourceforge.squirrel_sql.plugins.vertica.tab.DBObjectSourceTab;
import net.sourceforge.squirrel_sql.plugins.vertica.tab.ProjectionDetailTab;
import net.sourceforge.squirrel_sql.plugins.vertica.tab.ProjectionTab;
import net.sourceforge.squirrel_sql.plugins.vertica.tab.SequenceDetailTab;
import net.sourceforge.squirrel_sql.plugins.vertica.tab.UDFDetailTab;

public class VerticaPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(VerticaPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(VerticaPlugin.class);

    public String getInternalName() {
        return "vertica";
    }

    public String getDescriptiveName() {
        return "Vertica Plugin";
    }

    public String getVersion() {
        return "0.20";
    }

    public String getAuthor() {
        return "Vertica Team";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
    }

    public void unload() {
        super.unload();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                VerticaPlugin.this.updateObjectTree(session.getObjectTreeAPIOfActiveSessionWindow());
            }
        });
        return new PluginSessionCallbackAdaptor();
    }

    protected boolean isPluginSession(ISession session) {
        try {
            String driverName = session.getSQLConnection().getConnection().getMetaData().getDatabaseProductName().toUpperCase();
            if (driverName.startsWith("VERTICA DATABASE")) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    private void updateObjectTree(IObjectTreeAPI objTree) {
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new SysTableExpanderFactory(), DatabaseObjectType.TABLE_TYPE_DBO));
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new SequenceExpanderFactory(), DatabaseObjectType.SEQUENCE_TYPE_DBO));
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new UDTExpanderFactory(), VerticaObjectType.VUDT));
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new UDFExpanderFactory(), DatabaseObjectType.UDF_TYPE_DBO));
        objTree.addExpander(DatabaseObjectType.TABLE, (INodeExpander)new TableExpander());
        objTree.addExpander(VerticaObjectType.PROJECTION_PARENT, (INodeExpander)new ProjectionParentExpander());
        objTree.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new ContentPlusTab((ObjectTreePanel)objTree));
        objTree.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new ProjectionTab());
        objTree.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new DBObjectSourceTab());
        objTree.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ContentPlusTab((ObjectTreePanel)objTree));
        objTree.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new DBObjectSourceTab());
        objTree.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        objTree.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailTab());
        objTree.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new DatabaseObjectInfoTab());
        objTree.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new UDFDetailTab());
        objTree.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new DBObjectSourceTab());
        objTree.addDetailTab(VerticaObjectType.VUDT, (IObjectTab)new DatabaseObjectInfoTab());
        objTree.addDetailTab(VerticaObjectType.VUDT, (IObjectTab)new UDFDetailTab());
        objTree.addDetailTab(VerticaObjectType.PROJECTION, (IObjectTab)new DatabaseObjectInfoTab());
        objTree.addDetailTab(VerticaObjectType.PROJECTION, (IObjectTab)new ProjectionDetailTab());
        objTree.addDetailTab(VerticaObjectType.PROJECTION, (IObjectTab)new DBObjectSourceTab());
    }

    static interface i18n {
    }
}

