/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.vertica.tab;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.DataSetUpdateableTableModelImpl;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.ContentsTab;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.OrderByClausePanel;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.SQLFilterClauses;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.WhereClausePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.dbobj.BestRowIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ContentPlusTab
extends ContentsTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ContentPlusTab.class);
    private static final ILogger s_log = LoggerController.createLogger(ContentPlusTab.class);
    private DataSetUpdateableTableModelImpl _dataSetUpdateableTableModel = new DataSetUpdateableTableModelImpl();
    private SQLFilterClauses _sqlFilterClauses = new SQLFilterClauses();

    public ContentPlusTab(ObjectTreePanel treePanel) {
        super(treePanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDataSet createDataSet() throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ISession session = this.getSession();
        ISQLConnection conn = session.getSQLConnection();
        ISQLDatabaseMetaData md = session.getMetaData();
        Statement stmt = conn.createStatement();
        try {
            String pseudoColumn;
            SessionProperties props;
            ITableInfo ti;
            block27: {
                ti = this.getTableInfo();
                this._dataSetUpdateableTableModel.setTableInfo(ti);
                this._dataSetUpdateableTableModel.setSession(session);
                props = session.getProperties();
                if (props.getContentsLimitRows()) {
                    try {
                        if (!ti.getType().equals("SYSTEM TABLE")) {
                            stmt.setMaxRows(props.getContentsNbrRowsToShow());
                        }
                    }
                    catch (Exception ex) {
                        s_log.error((Object)"Error on Statement.setMaxRows()", (Throwable)ex);
                    }
                }
                pseudoColumn = "";
                try {
                    BestRowIdentifier[] rowIDs = md.getBestRowIdentifier(ti);
                    for (int i = 0; i < rowIDs.length; ++i) {
                        short pseudo = rowIDs[i].getPseudoColumn();
                        if (pseudo != 2) continue;
                        pseudoColumn = " ," + rowIDs[i].getColumnName();
                        break;
                    }
                }
                catch (Throwable th) {
                    if (!s_log.isDebugEnabled()) break block27;
                    s_log.debug((Object)"getBestRowIdentifier not supported for this table ", th);
                }
            }
            ResultSet rs = null;
            try {
                StringBuffer buf = new StringBuffer();
                buf.append("select tbl.*").append(pseudoColumn).append(" from ").append(ti.getQualifiedName()).append(" tbl");
                String clause = this._sqlFilterClauses.get(WhereClausePanel.getClauseIdentifier(), ti.getQualifiedName());
                if (clause != null && clause.length() > 0) {
                    buf.append(" where ").append(clause);
                }
                if ((clause = this._sqlFilterClauses.get(OrderByClausePanel.getClauseIdentifier(), ti.getQualifiedName())) != null && clause.length() > 0) {
                    buf.append(" order by ").append(clause);
                }
                if (!ti.getType().equals("SYSTEM TABLE")) {
                    buf.append(" limit " + props.getContentsNbrRowsToShow());
                }
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("createDataSet running SQL: " + buf.toString()));
                }
                rs = stmt.executeQuery(buf.toString());
            }
            catch (SQLException ex) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("createDataSet: exception from pseudocolumn query - " + ex), (Throwable)ex);
                }
                if (pseudoColumn.length() == 0) {
                    throw ex;
                }
                pseudoColumn = "";
                StringBuffer buf = new StringBuffer();
                buf.append("select *").append(" from ").append(ti.getQualifiedName()).append(" tbl");
                String clause = this._sqlFilterClauses.get(WhereClausePanel.getClauseIdentifier(), ti.getQualifiedName());
                if (clause != null && clause.length() > 0) {
                    buf.append(" where ").append(clause);
                }
                if ((clause = this._sqlFilterClauses.get(OrderByClausePanel.getClauseIdentifier(), ti.getQualifiedName())) != null && clause.length() > 0) {
                    buf.append(" order by ").append(clause);
                }
                if (!ti.getType().equals("SYSTEM TABLE")) {
                    buf.append(" limit " + props.getContentsNbrRowsToShow());
                }
                rs = stmt.executeQuery(buf.toString());
            }
            ResultSetDataSet rsds = new ResultSetDataSet(md.getColumnInfo(ti));
            rsds.setContentsTabResultSet(rs, this._dataSetUpdateableTableModel.getFullTableName(), DialectFactory.getDialectType((ISQLDatabaseMetaData)md));
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (pseudoColumn.length() > 0) {
                this._dataSetUpdateableTableModel.setRowIDCol(rsds.getColumnCount() - 1);
            }
            resultSetDataSet = rsds;
        }
        catch (Throwable throwable) {
            try {
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            catch (SQLException ex) {
                throw new DataSetException((Throwable)ex);
            }
        }
        SQLUtilities.closeStatement((Statement)stmt);
        return resultSetDataSet;
    }

    public String getTitle() {
        return i18n.TITLE;
    }

    public String getHint() {
        return i18n.HINT;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String HINT = ContentPlusTab.access$000().getString("ContentPlusTab.hint");
        public static final String TITLE = ContentPlusTab.access$000().getString("ContentPlusTab.title");
    }
}

