/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.favs;

import javax.swing.JPanel;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.favs.Folder;
import net.sourceforge.squirrel_sql.plugins.favs.FolderNode;
import net.sourceforge.squirrel_sql.plugins.favs.FoldersCache;

final class QueryTreeModel
extends DefaultTreeModel {
    private static ILogger s_log = LoggerController.createLogger(QueryTreeModel.class);
    private IApplication _app;
    private FoldersCache _cache;
    private JPanel _emptyPnl = new JPanel();
    private MyModelListener _modelListener = new MyModelListener();

    QueryTreeModel(IApplication app, FoldersCache cache) throws IllegalArgumentException {
        super(new FolderNode(new Folder(null, "Root")));
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Null FoldersCache passed");
        }
        this.addTreeModelListener(this._modelListener);
        this._app = app;
        this._cache = cache;
        this.loadTree();
    }

    private void loadTree() {
        this._modelListener.stopListening();
        try {
            Folder rootFolder = this._cache.getRootFolder();
            if (rootFolder != null) {
                FolderNode rootNode = new FolderNode(rootFolder);
                this.setRoot(rootNode);
                this.loadSubFolders(rootNode);
            } else {
                rootFolder = new Folder(null, "Root");
                this.setRoot(new FolderNode(rootFolder));
                this._cache.setRootFolder(rootFolder);
            }
            this.reload();
        }
        finally {
            this._modelListener.startListening();
        }
    }

    private void loadSubFolders(FolderNode node) {
        Folder[] subFolders = node.getFolder().getSubFolders();
        for (int i = 0; i < subFolders.length; ++i) {
            FolderNode childNode = new FolderNode(subFolders[i]);
            node.add(childNode);
            this.loadSubFolders(childNode);
        }
    }

    private static class MyModelListener
    implements TreeModelListener {
        private boolean _listening = true;

        private MyModelListener() {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent evt) {
            s_log.debug((Object)"treeStructureChanged");
        }

        @Override
        public void treeNodesInserted(TreeModelEvent evt) {
            s_log.debug((Object)"treeNodesInserted");
        }

        @Override
        public void treeNodesChanged(TreeModelEvent evt) {
            s_log.debug((Object)"treeNodesChanged");
            Object[] objs = evt.getChildren();
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    FolderNode node = (FolderNode)objs[i];
                    Folder folder = node.getFolder();
                    String newName = node.toString();
                    String oldName = folder.getName();
                    s_log.debug((Object)oldName);
                    if (newName.equals(oldName)) continue;
                    try {
                        folder.setName(newName);
                        continue;
                    }
                    catch (Exception ex) {
                        s_log.error((Object)"Error", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent evt) {
            s_log.debug((Object)"treeNodesRemoved");
        }

        void startListening() {
            this._listening = true;
        }

        void stopListening() {
            this._listening = false;
        }
    }
}

