/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.favs;

import java.io.IOException;
import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.plugin.DefaultPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.plugins.favs.DeleteSavedQueriesFolderAction;
import net.sourceforge.squirrel_sql.plugins.favs.FoldersCache;
import net.sourceforge.squirrel_sql.plugins.favs.NewSavedQueriesFolderAction;
import net.sourceforge.squirrel_sql.plugins.favs.OrganizeSavedQueriesAction;
import net.sourceforge.squirrel_sql.plugins.favs.RenameSavedQueriesFolderAction;

public class SavedQueriesPlugin
extends DefaultPlugin {
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private FoldersCache _cache;

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "favs";
    }

    public String getDescriptiveName() {
        return "Saved Queries Plugin";
    }

    public String getVersion() {
        return "0.1";
    }

    public String getAuthor() {
        return "Udi Ipalawatte";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        try {
            this._cache = new FoldersCache(app, this.getPluginUserSettingsFolder());
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this._cache.load();
        this._resources = this._resourcesFactory.createResource("net.sourceforge.squirrel_sql.plugins.favs.saved_queries", (IPlugin)this);
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new DeleteSavedQueriesFolderAction(app, this._resources)));
        coll.add((Action)((Object)new NewSavedQueriesFolderAction(app, this._resources)));
        coll.add((Action)((Object)new OrganizeSavedQueriesAction(app, this._resources, this._cache)));
        coll.add((Action)((Object)new RenameSavedQueriesFolderAction(app, this._resources)));
        this.createMenu();
    }

    public void unload() {
        this._cache.save();
        super.unload();
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu menu = this._resources.createMenu("queries");
        this._resources.addToMenu(coll.get(OrganizeSavedQueriesAction.class), menu);
        menu.addSeparator();
        app.addToMenu(1, menu);
    }

    private static interface IMenuResourceKeys {
        public static final String QUERIES = "queries";
    }
}

