/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class Version {
    private static final String APP_NAME = "SQuirreL SQL Client";
    private static final String COPYRIGHT = "Copyright (c) 2001-2019\nColin Bell, Gerd Wagner, Rob Manning and others";
    private static final String WEB_SITE = "http://www.squirrelsql.org";
    private static String shortVersion = null;

    public static String getApplicationName() {
        return APP_NAME;
    }

    public static synchronized String getShortVersion() {
        if (shortVersion == null) {
            InputStream is = Version.class.getResourceAsStream("Version.properties");
            Properties props = new Properties();
            try {
                props.load(is);
                shortVersion = props.getProperty("squirrelsql.version");
            }
            catch (IOException e) {
                shortVersion = "Unknown Version";
            }
        }
        return shortVersion;
    }

    public static void main(String[] args) {
        System.out.println("Version: " + Version.getShortVersion());
    }

    public static String getVersion() {
        StringBuffer buf = new StringBuffer();
        buf.append(APP_NAME);
        buf.append(" ");
        if (!Version.isSnapshotVersion()) {
            buf.append("Version ");
        }
        buf.append(Version.getShortVersion());
        return buf.toString();
    }

    public static boolean isSnapshotVersion() {
        return Version.getShortVersion().toLowerCase().startsWith("snapshot");
    }

    public static String getCopyrightStatement() {
        return COPYRIGHT;
    }

    public static String getWebSite() {
        return WEB_SITE;
    }

    public static boolean supportsUsedJDK() {
        String vmVer = System.getProperty("java.vm.version");
        return !vmVer.startsWith("0") && !vmVer.startsWith("1.0") && !vmVer.startsWith("1.1") && !vmVer.startsWith("1.2") && !vmVer.startsWith("1.3") && !vmVer.startsWith("1.4") && !vmVer.startsWith("1.5");
    }

    public static String getUnsupportedJDKMessage() {
        String[] params = new String[]{System.getProperty("java.vm.version"), System.getProperty("java.home")};
        return StringManagerFactory.getStringManager(Version.class).getString("Application.error.unsupportedJDKVersion", params);
    }

    public static boolean isJDK14() {
        String vmVer = System.getProperty("java.vm.version");
        return vmVer.startsWith("1.4");
    }

    public static boolean isJDK16OrAbove() {
        String vmVer = System.getProperty("java.vm.version").substring(0, 3);
        return vmVer.compareTo("1.6") >= 0;
    }
}

