/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.mainframe.IHasJDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.mainframe.WidgetUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public abstract class TileInternalFramesAction
extends BaseAction
implements IHasJDesktopPane {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TileInternalFramesAction.class);
    private IDesktopContainer _desktop;
    private IApplication _app;

    public TileInternalFramesAction(IApplication app) {
        super(s_stringMgr.getString("TileInternalFramesAction.title"));
        this._app = app;
    }

    @Override
    public void setDesktopContainer(IDesktopContainer value) {
        this._desktop = value;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        IWidget[] widgets;
        int cells;
        if (this._desktop != null && this._app.getDesktopStyle().isInternalFrameStyle() && (cells = (widgets = WidgetUtils.getNonMinimizedNonToolWindows(this._desktop.getAllWidgets())).length) > 0) {
            RowColumnCount rcc = this.getRowColumnCount(cells);
            int rows = rcc._rowCount;
            int cols = rcc._columnCount;
            Dimension desktopSize = this._desktop.getSize();
            int width = desktopSize.width / cols;
            int height = desktopSize.height / rows;
            int xPos = 0;
            int yPos = 0;
            for (int y = 0; y < rows; ++y) {
                int idx;
                for (int x = 0; x < cols && (idx = y + x * rows) < cells; ++x) {
                    JInternalFrame frame = widgets[idx].getInternalFrame();
                    if (frame.isClosed()) continue;
                    if (frame.isIcon()) {
                        try {
                            frame.setIcon(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else if (frame.isMaximum()) {
                        try {
                            frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                    frame.reshape(xPos, yPos, width, height);
                    xPos += width;
                }
                xPos = 0;
                yPos += height;
            }
        }
    }

    protected abstract RowColumnCount getRowColumnCount(int var1);

    public static final class RowColumnCount {
        protected final int _rowCount;
        protected final int _columnCount;

        public RowColumnCount(int rowCount, int columnCount) {
            this._rowCount = rowCount;
            this._columnCount = columnCount;
        }
    }
}

