/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences.codereformat;

import com.jidesoft.swing.MultilineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.KeywordBehaviourPref;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.KeywordBehaviourPrefCtrl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class FormatSqlPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FormatSqlPanel.class);
    JFormattedTextField txtIndentCount;
    JCheckBox chkIndentSections = new JCheckBox(s_stringMgr.getString("codereformat.FormatSqlPanel.indent.sections"));
    JRadioButton radCommasAtLineBeginYes;
    JRadioButton radCommasAtLineBeginNo;
    JFormattedTextField txtPreferedLineLength;
    ArrayList<KeywordBehaviourPrefCtrl> keywordBehaviourPrefCtrls = new ArrayList();
    JCheckBox chkDoInsertValuesAlign;
    JCheckBox _chkLineBreakFor_AND_OR_in_FROM_clause = new JCheckBox(s_stringMgr.getString("codereformat.FormatSqlPanel.checkbox.lineBreakFor_AND_OR_in_FROM_clause"));
    JTextArea txtExampleSqls = new JTextArea();
    JComboBox _cboColumnListSplitMode = new JComboBox();

    public FormatSqlPanel(KeywordBehaviourPref[] keywordBehaviourPrefs) {
        this.setLayout(new BorderLayout());
        JScrollPane scr = new JScrollPane(this.createControlsPanel(keywordBehaviourPrefs));
        scr.setHorizontalScrollBarPolicy(31);
        this.add((Component)scr, "West");
        this.add((Component)new JScrollPane(this.txtExampleSqls), "Center");
    }

    private JPanel createControlsPanel(KeywordBehaviourPref[] keywordBehaviourPrefs) {
        JPanel ret = new JPanel(new GridBagLayout());
        int gridy = 0;
        int additionalRightInsetForScrollbar = 10;
        GridBagConstraints gbc = new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("codereformat.FormatSqlPanel.indentCount")), gbc);
        gbc = new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        this.txtIndentCount = new JFormattedTextField(NumberFormat.getInstance());
        this.txtIndentCount.setColumns(7);
        ret.add((Component)this.txtIndentCount, gbc);
        gbc = new GridBagConstraints(1, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        ret.add((Component)this.chkIndentSections, gbc);
        gbc = new GridBagConstraints(1, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 10, 5 + additionalRightInsetForScrollbar), 0, 0);
        ret.add((Component)this.createCommasPanel(), gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("codereformat.FormatSqlPanel.preferedLineLen")), gbc);
        gbc = new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.txtPreferedLineLength = new JFormattedTextField(NumberFormat.getInstance());
        this.txtPreferedLineLength.setColumns(7);
        ret.add((Component)this.txtPreferedLineLength, gbc);
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("codereformat.FormatSqlPanel.column.list.behavior")), gbc);
        gbc = new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        ret.add((Component)this._cboColumnListSplitMode, gbc);
        gbc = new GridBagConstraints(0, ++gridy, 2, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("codereformat.FormatSqlPanel.keywordBehavior")), gbc);
        for (KeywordBehaviourPref keywordBehaviourPref : keywordBehaviourPrefs) {
            this.keywordBehaviourPrefCtrls.add(this.createKeywordBehaviourPrefCtrl(ret, keywordBehaviourPref, ++gridy, additionalRightInsetForScrollbar));
        }
        gbc = new GridBagConstraints(1, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        this.chkDoInsertValuesAlign = new JCheckBox(s_stringMgr.getString("codereformat.FormatSqlPanel.tryAlignInsertValueStatements"));
        ret.add((Component)this.chkDoInsertValuesAlign, gbc);
        MultilineLabel lblLineBreakFor_AND_OR_in_FROM_clause = new MultilineLabel(s_stringMgr.getString("codereformat.FormatSqlPanel.explain.lineBreakFor_AND_OR_in_FROM_clause"));
        lblLineBreakFor_AND_OR_in_FROM_clause.setText(s_stringMgr.getString("codereformat.FormatSqlPanel.explain.lineBreakFor_AND_OR_in_FROM_clause"));
        gbc = new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)lblLineBreakFor_AND_OR_in_FROM_clause, gbc);
        gbc = new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        ret.add((Component)this._chkLineBreakFor_AND_OR_in_FROM_clause, gbc);
        return ret;
    }

    private JPanel createCommasPanel() {
        JPanel ret = new JPanel(new GridLayout(2, 1, 5, 0));
        ret.setBorder(BorderFactory.createEtchedBorder());
        this.radCommasAtLineBeginNo = new JRadioButton(s_stringMgr.getString("codereformat.FormatSqlPanel.commas.at.line.begin.no"));
        ret.add(this.radCommasAtLineBeginNo);
        this.radCommasAtLineBeginYes = new JRadioButton(s_stringMgr.getString("codereformat.FormatSqlPanel.commas.at.line.begin.yes"));
        ret.add(this.radCommasAtLineBeginYes);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radCommasAtLineBeginYes);
        bg.add(this.radCommasAtLineBeginNo);
        return ret;
    }

    private KeywordBehaviourPrefCtrl createKeywordBehaviourPrefCtrl(JPanel toAddTo, KeywordBehaviourPref keywordBehaviourPref, int gridy, int additionalRightInsetForScrollbar) {
        GridBagConstraints gbc = new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        toAddTo.add((Component)new JLabel(keywordBehaviourPref.getKeyWord()), gbc);
        gbc = new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5 + additionalRightInsetForScrollbar), 0, 0);
        JComboBox cbo = new JComboBox();
        toAddTo.add(cbo, gbc);
        return new KeywordBehaviourPrefCtrl(cbo, keywordBehaviourPref);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    public static enum KeywordBehaviour {
        ALONE_IN_LINE(1, FormatSqlPanel.access$000().getString("codereformat.aloneInLine"), 2),
        START_NEW_LINE(2, FormatSqlPanel.access$000().getString("codereformat.startNewLine"), 0),
        NO_INFLUENCE_ON_NEW_LINE(3, FormatSqlPanel.access$000().getString("codereformat.noInfluenceOnNewLine"), null);

        private String _title;
        private Integer _pieceMarkerSpecType;
        private int _id;

        private KeywordBehaviour(int id, String title, Integer pieceMarkerSpecType) {
            this._id = id;
            this._title = title;
            this._pieceMarkerSpecType = pieceMarkerSpecType;
        }

        public String toString() {
            return this._title;
        }

        public int getID() {
            return this._id;
        }

        public static KeywordBehaviour forId(int id) {
            for (KeywordBehaviour keywordBehaviour : KeywordBehaviour.values()) {
                if (id != keywordBehaviour.getID()) continue;
                return keywordBehaviour;
            }
            throw new IllegalArgumentException("Invalid ID: " + id);
        }

        public Integer getPieceMarkerSpecType() {
            return this._pieceMarkerSpecType;
        }
    }
}

