/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.session.Session;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;

public class SimpleSessionListenerManager {
    private final IApplication _app;
    private final Session _session;
    private ArrayList<SimpleSessionListener> _listeners = new ArrayList();
    private final SessionAdapter _sessionAdapter;

    public SimpleSessionListenerManager(IApplication app, Session session) {
        this._app = app;
        this._session = session;
        this._sessionAdapter = new SessionAdapter(){

            @Override
            public void sessionClosed(SessionEvent evt) {
                SimpleSessionListenerManager.this.onSessionClosed(evt);
            }
        };
        this._app.getSessionManager().addSessionListener(this._sessionAdapter);
    }

    private void onSessionClosed(SessionEvent evt) {
        SimpleSessionListener[] simpleSessionListeners;
        if (!evt.getSession().getIdentifier().equals(this._session.getIdentifier())) {
            return;
        }
        for (SimpleSessionListener simpleSessionListener : simpleSessionListeners = this._listeners.toArray(new SimpleSessionListener[this._listeners.size()])) {
            simpleSessionListener.sessionClosed();
        }
        this._app.getSessionManager().removeSessionListener(this._sessionAdapter);
    }

    public void addListener(SimpleSessionListener simpleSessionListener) {
        this._listeners.add(simpleSessionListener);
    }

    public void removeListener(SimpleSessionListener simpleSessionListener) {
        this._listeners.remove(simpleSessionListener);
    }
}

