/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.util.Arrays;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooser;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public enum MarkDuplicatesMode {
    DUPLICATE_VALUES_IN_COLUMNS(Main.getApplication().getResources().getIcon("duplicateValuesInColumns"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateValuesInColumns.text"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateValuesInColumns.tooltip")),
    DUPLICATE_CONSECUTIVE_VALUES_IN_COLUMNS(Main.getApplication().getResources().getIcon("duplicateValuesInColumnsIfConsecutive"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateValuesInColumnsIfConsecutive.text"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateValuesInColumnsIfConsecutive.tooltip")),
    DUPLICATE_ROWS(Main.getApplication().getResources().getIcon("duplicateRows"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateRows.text"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateRows.tooltip")),
    DUPLICATE_CONSECUTIVE_ROWS(Main.getApplication().getResources().getIcon("duplicateRowsIfConsecutive"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateRowsIfConsecutive.text"), StaticsAccess.s_stringMgr.getString("MarkDuplicatesMode.duplicateRowsIfConsecutive.tooltip"));

    private final ImageIcon _icon;
    private final String _text;
    private final String _toolTip;

    private MarkDuplicatesMode(ImageIcon icon, String text, String toolTip) {
        this._icon = icon;
        this._text = text;
        this._toolTip = toolTip;
    }

    public static MarkDuplicatesMode getModeByIcon(Icon icon) {
        Optional<MarkDuplicatesMode> ret = Arrays.stream(MarkDuplicatesMode.values()).filter(e -> e._icon == icon).findFirst();
        if (!ret.isPresent()) {
            throw new IllegalStateException("No mode for Icon " + icon);
        }
        return ret.get();
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getText() {
        return this._text;
    }

    public String getToolTipText() {
        return this._toolTip;
    }

    public JToggleButton findButton(ButtonChooser buttonChooser) {
        Optional<AbstractButton> ret = buttonChooser.getAllButtons().stream().filter(b -> b.getIcon() == this._icon).findFirst();
        if (!ret.isPresent()) {
            throw new IllegalStateException("No Button found for mode " + this.name());
        }
        return (JToggleButton)ret.get();
    }

    private static class StaticsAccess {
        static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MarkDuplicatesMode.class);

        private StaticsAccess() {
        }
    }
}

