/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset;

import java.util.Arrays;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.ResultAsTextLineCallback;

public class ResultAsText {
    private static final int COLUMN_PADDING = 2;
    private ColumnDisplayDefinition[] _colDefs;
    private int _rowCount = 0;
    private StringBuffer _text = new StringBuffer();
    private ResultAsTextLineCallback _resultAsTextLineCallback;

    public ResultAsText(ColumnDisplayDefinition[] colDefs, boolean showHeadings, ResultAsTextLineCallback resultAsTextLineCallback) {
        this._resultAsTextLineCallback = resultAsTextLineCallback;
        if (showHeadings) {
            int i;
            this._colDefs = colDefs;
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < colDefs.length; ++i) {
                String headerValue = colDefs[i].getColumnHeading();
                buf.append(this.format(headerValue, colDefs[i].getDisplayWidth(), ' '));
            }
            this.addLine(buf.toString());
            buf = new StringBuffer();
            for (i = 0; i < colDefs.length; ++i) {
                buf.append(this.format("", colDefs[i].getDisplayWidth(), '-'));
            }
            this.addLine(buf.toString());
        }
    }

    public void addRow(Object[] row) {
        ++this._rowCount;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < row.length; ++i) {
            String cellValue = CellComponentFactory.renderObject(row[i], this._colDefs[i]);
            buf.append(this.format(cellValue, this._colDefs[i].getDisplayWidth(), ' '));
        }
        this.addLine(buf.toString());
    }

    private void addLine(String line) {
        this._resultAsTextLineCallback.addLine(line + "\n");
    }

    private String format(String data, int displaySize, char fillChar) {
        int extraPadding;
        data = data.replace('\n', ' ');
        data = data.replace('\r', ' ');
        data = data.replace('\u0000', ' ');
        data = data.replace('\f', ' ');
        StringBuffer output = new StringBuffer(data);
        int maxTextOutputColumnWidth = Main.getApplication().getSquirrelPreferences().getMaxTextOutputColumnWidth();
        if (displaySize > maxTextOutputColumnWidth) {
            displaySize = maxTextOutputColumnWidth;
        }
        if (output.length() > displaySize) {
            output.setLength(displaySize);
        }
        if ((extraPadding = (displaySize += 2) - output.length()) > 0) {
            char[] padData = new char[extraPadding];
            Arrays.fill(padData, fillChar);
            output.append(padData);
        }
        return output.toString();
    }

    public void clear() {
        this._rowCount = 0;
        this._text.setLength(0);
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public String getText() {
        return this._text.toString();
    }
}

