/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.copyseparatedby;

import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.copyseparatedby.CopySeparatedByDlg;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CopySeparatedByCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CopySeparatedByCtrl.class);
    private static final String PREF_KEY_COPYSEPARATEDBYCTRL_CELL_SEPARATOR = "Squirrel.copyseparatedbyctrl.cell.separator";
    private static final String PREF_KEY_COPYSEPARATEDBYCTRL_ROW_SEPARATOR = "Squirrel.copyseparatedbyctrl.row.separator";
    private static final String PREF_KEY_COPYSEPARATEDBYCTRL_ROW_PREFERED_LINE_LEN = "Squirrel.copyseparatedbyctrl.prefered.line.len";
    private CopySeparatedByDlg _copySeparatedByDlg;
    private boolean _enableRowSeparator;
    private String _cellSeparator = "";
    private String _rowSeparator = "";
    private boolean _isOk;
    private int _preferedLineLength;

    public CopySeparatedByCtrl(DataSetViewerTable table, boolean enableRowSeparator) {
        this._copySeparatedByDlg = new CopySeparatedByDlg(GUIUtils.getOwningFrame(table));
        this._enableRowSeparator = enableRowSeparator;
        this._copySeparatedByDlg.txtCellSeparator.setText(Props.getString(PREF_KEY_COPYSEPARATEDBYCTRL_CELL_SEPARATOR, ","));
        this._copySeparatedByDlg.txtLineLength.setInt(Props.getInt(PREF_KEY_COPYSEPARATEDBYCTRL_ROW_PREFERED_LINE_LEN, 100));
        this._copySeparatedByDlg.txtRowSeparator.setText(Props.getString(PREF_KEY_COPYSEPARATEDBYCTRL_ROW_SEPARATOR, "\\n"));
        if (!this._enableRowSeparator) {
            this._copySeparatedByDlg.txtRowSeparator.setEnabled(false);
            this._copySeparatedByDlg._lblRowSeparator.setEnabled(false);
            this._copySeparatedByDlg.txtRowSeparator.setText(null);
        }
        this._copySeparatedByDlg.btnOk.addActionListener(e -> this.onOk());
        this._copySeparatedByDlg.btnCancel.addActionListener(e -> this.onCancel());
        GUIUtils.forceFocus(this._copySeparatedByDlg.txtCellSeparator);
        this._copySeparatedByDlg.setVisible(true);
    }

    private void onCancel() {
        this._copySeparatedByDlg.setVisible(false);
        this._copySeparatedByDlg.dispose();
    }

    private void onOk() {
        if (0 >= this._copySeparatedByDlg.txtLineLength.getInt()) {
            JOptionPane.showConfirmDialog(this._copySeparatedByDlg, s_stringMgr.getString("CopySeparatedByCtrl.invalid.line.length"));
            return;
        }
        String text = "";
        if (null != this._copySeparatedByDlg.txtCellSeparator.getText()) {
            text = this._copySeparatedByDlg.txtCellSeparator.getText();
        }
        Props.putString(PREF_KEY_COPYSEPARATEDBYCTRL_CELL_SEPARATOR, text);
        if (null != this._copySeparatedByDlg.txtCellSeparator.getText()) {
            this._cellSeparator = this.doReplacements(this._copySeparatedByDlg.txtCellSeparator.getText());
        }
        Props.putInt(PREF_KEY_COPYSEPARATEDBYCTRL_ROW_PREFERED_LINE_LEN, this._copySeparatedByDlg.txtLineLength.getInt());
        this._preferedLineLength = this._copySeparatedByDlg.txtLineLength.getInt();
        if (this._enableRowSeparator && null != this._copySeparatedByDlg.txtRowSeparator.getText()) {
            text = "";
            if (null != this._copySeparatedByDlg.txtRowSeparator.getText()) {
                text = this._copySeparatedByDlg.txtRowSeparator.getText();
            }
            Props.putString(PREF_KEY_COPYSEPARATEDBYCTRL_ROW_SEPARATOR, text);
            this._rowSeparator = this.doReplacements(this._copySeparatedByDlg.txtRowSeparator.getText());
        }
        this._isOk = true;
        this._copySeparatedByDlg.setVisible(false);
        this._copySeparatedByDlg.dispose();
    }

    private String doReplacements(String text) {
        return text.replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t");
    }

    public String getCellSeparator() {
        return this._cellSeparator;
    }

    public String getRowSeparator() {
        return this._rowSeparator;
    }

    public int getPreferedLineLength() {
        return this._preferedLineLength;
    }

    public boolean isOk() {
        return this._isOk;
    }
}

