/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrameCallback;

public class OracleInternalFrame
extends SessionDialogWidget {
    private static final String PREF_KEY_ORACLE_FRAME_REPL = "@@";
    private static final String PREF_KEY_ORACLE_FRAME_X = "Squirrel.oracle.@@_X";
    private static final String PREF_KEY_ORACLE_FRAME_Y = "Squirrel.oracle.@@_Y";
    private static final String PREF_KEY_ORACLE_FRAME_WIDTH = "Squirrel.oracle.@@_WIDTH";
    private static final String PREF_KEY_ORACLE_FRAME_HEIGHT = "Squirrel.oracle.@@_HEIGHT";
    private static final String PREF_KEY_ORACLE_FRAME_STAY_ON_TOP = "Squirrel.oracle.@@_STAY_ON_TOP";
    private static final String PREF_KEY_ORACLE_FRAME_AUTO_REFRESH_SEC = "Squirrel.oracle.@@_AUTO_REFRESH_SEC";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OracleInternalFrame.class);
    private static final ILogger s_log = LoggerController.createLogger(OracleInternalFrame.class);
    private String _repl = "";

    public OracleInternalFrame(ISession session, String title) {
        super(title, true, true, true, true, session);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    protected void initFromPrefs(String repl, OracleInternalFrameCallback callBack) {
        this._repl = repl;
        final int x = Props.getInt((String)PREF_KEY_ORACLE_FRAME_X.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)0);
        final int y = Props.getInt((String)PREF_KEY_ORACLE_FRAME_Y.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)0);
        final int width = Props.getInt((String)PREF_KEY_ORACLE_FRAME_WIDTH.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)400);
        final int height = Props.getInt((String)PREF_KEY_ORACLE_FRAME_HEIGHT.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)200);
        boolean stayOnTop = Props.getBoolean((String)PREF_KEY_ORACLE_FRAME_STAY_ON_TOP.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (boolean)false);
        int autoRefeshPeriod = Props.getInt((String)PREF_KEY_ORACLE_FRAME_AUTO_REFRESH_SEC.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)10);
        autoRefeshPeriod = Math.max(1, autoRefeshPeriod);
        callBack.createPanelAndToolBar(stayOnTop, autoRefeshPeriod);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle rectMain = OracleInternalFrame.this.getSession().getApplication().getMainFrame().getDesktopContainer().getBounds();
                Rectangle rect = new Rectangle();
                rect.x = x;
                if (rectMain.width - x < 50) {
                    rect.x = 0;
                }
                rect.y = y;
                if (rectMain.height - y < 50) {
                    rect.y = 0;
                }
                rect.width = Math.max(100, width);
                rect.height = Math.max(100, height);
                if (rect.x + rect.width > rectMain.width || rect.y + rect.height > rectMain.height) {
                    rect.x = 0;
                    rect.width = 400;
                    rect.y = 0;
                    rect.height = 200;
                }
                try {
                    OracleInternalFrame.this.setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    s_log.error((Object)e);
                }
                OracleInternalFrame.this.setBounds(rect);
                OracleInternalFrame.this.setVisible(true);
            }
        });
    }

    protected void internalFrameClosing(boolean stayOnTop, int autoRefreshPeriod) {
        Rectangle rect = this.getBounds();
        if (rect != null) {
            Props.putInt((String)PREF_KEY_ORACLE_FRAME_X.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)rect.x);
            Props.putInt((String)PREF_KEY_ORACLE_FRAME_Y.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)rect.y);
            Props.putInt((String)PREF_KEY_ORACLE_FRAME_WIDTH.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)rect.width);
            Props.putInt((String)PREF_KEY_ORACLE_FRAME_HEIGHT.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)rect.height);
        }
        Props.putBoolean((String)PREF_KEY_ORACLE_FRAME_STAY_ON_TOP.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (boolean)stayOnTop);
        Props.putInt((String)PREF_KEY_ORACLE_FRAME_AUTO_REFRESH_SEC.replaceAll(PREF_KEY_ORACLE_FRAME_REPL, this._repl), (int)autoRefreshPeriod);
    }

    public class OracleToolBar
    extends ToolBar {
        private static final long serialVersionUID = 1L;
        private JCheckBox _stayOnTop;

        protected void addStayOnTop(boolean stayOnTop) {
            this._stayOnTop = new JCheckBox(s_stringMgr.getString("oracle.dboutputStayOnTop"), false);
            this._stayOnTop.setSelected(stayOnTop);
            this._stayOnTop.setVisible(OracleInternalFrame.this.getSession().getApplication().getDesktopStyle().supportsLayers());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OracleToolBar.this.onStayOnTopChanged(OracleToolBar.this._stayOnTop.isSelected());
                    OracleToolBar.this._stayOnTop.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OracleToolBar.this.onStayOnTopChanged(OracleToolBar.this._stayOnTop.isSelected());
                        }
                    });
                }
            });
            this.add(this._stayOnTop);
        }

        private void onStayOnTopChanged(boolean selected) {
            if (selected) {
                OracleInternalFrame.this.setLayer((int)JLayeredPane.PALETTE_LAYER);
            } else {
                OracleInternalFrame.this.setLayer((int)JLayeredPane.DEFAULT_LAYER);
            }
            OracleInternalFrame.this.toFront();
        }

        public boolean isStayOnTop() {
            return this._stayOnTop.isSelected();
        }
    }
}

