/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.expander;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IObjectTypes;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;

public class SessionParentExpander
implements INodeExpander {
    private static String SQL = "select sid||' ('||schemaname||')' from sys.v_$session";
    private IObjectTypes _objectTypes;

    public SessionParentExpander(IObjectTypes objectTypes) {
        this._objectTypes = objectTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        String schemaName = parentDbinfo.getSchemaName();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(SQL);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DatabaseObjectInfo doi = new DatabaseObjectInfo(null, schemaName, rs.getString(1), this._objectTypes.getSession(), (ISQLDatabaseMetaData)md);
                childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)doi));
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs, (boolean)true);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
        return childNodes;
    }
}

