/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.AddBookmarkAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkManager;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BoomarksExternalServiceImpl;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.CompleteBookmarkAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.DefaultBookmarksFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.EditBookmarksAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.RunBookmarkAction;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.SQLBookmarkPreferencesController;

public class SQLBookmarkPlugin
extends DefaultSessionPlugin {
    private static final ILogger s_log = LoggerController.createLogger(SQLBookmarkPlugin.class);
    private ArrayList<ISQLPanelAPI> _sqlPanelAPIsListeningForBookmarks = new ArrayList();
    private static final String BOOKMARKS_PROPS_FILE = "bookmarks.properties";
    static final String BOOKMARK_PROP_DEFAULT_MARKS_IN_POPUP = "squirrelMarksInPopup";
    static final String BOOKMARK_PROP_USE_CONTAINS_TO_FILTER_BOOKMARKS = "useContainsToFilterBookmarks";
    private Properties _boomarkProps;
    public static final String RESOURCE_PATH = "net.sourceforge.squirrel_sql.plugins.sqlbookmark.sqlbookmark";
    private static ILogger logger = LoggerController.createLogger(SQLBookmarkPlugin.class);
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private JMenu menu;
    private BookmarkManager bookmarkManager;

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getVersion() {
        return "2.0.1";
    }

    public String getAuthor() {
        return "Joseph Mocker";
    }

    public String getContributors() {
        return "Gerd Wagner";
    }

    public String getInternalName() {
        return "sqlbookmark";
    }

    public String getDescriptiveName() {
        return "SQL Bookmark Plugin";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    protected IResources getResources() {
        return this._resources;
    }

    protected String getResourceString(String name) {
        return this._resources.getString(name);
    }

    BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    protected void setBookmarkManager(BookmarkManager bookmarks) {
        this.bookmarkManager = bookmarks;
    }

    public Object getExternalService() {
        return new BoomarksExternalServiceImpl(this);
    }

    public synchronized void initialize() throws PluginException {
        IApplication app;
        block2: {
            super.initialize();
            app = this.getApplication();
            this._resources = this._resourcesFactory.createResource(RESOURCE_PATH, (IPlugin)this);
            this.bookmarkManager = new BookmarkManager(this);
            try {
                this.bookmarkManager.load();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block2;
                logger.error((Object)"Problem loading bookmarkManager", (Throwable)e);
            }
        }
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new AddBookmarkAction(app, this._resources, this)));
        coll.add((Action)((Object)new EditBookmarksAction(app, this._resources, this)));
        coll.add((Action)((Object)new RunBookmarkAction(app, this._resources, this)));
        this.createMenu();
        this.rebuildMenu();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SQLBookmarkPlugin.this.addBookmarkAction(session);
            }
        });
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
                ActionCollection coll = SQLBookmarkPlugin.this.getApplication().getActionCollection();
                sqlInternalFrame.addSeparatorToToolbar();
                sqlInternalFrame.addToToolbar(coll.get(AddBookmarkAction.class));
                sqlInternalFrame.addToToolbar(coll.get(EditBookmarksAction.class));
                SQLBookmarkPlugin.this.initSqlPanel(sqlInternalFrame.getMainSQLPanelAPI());
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
                SQLBookmarkPlugin.this.initSqlPanel(additionalSQLTab.getSQLPanelAPI());
            }
        };
        return ret;
    }

    private void addBookmarkAction(ISession session) {
        ActionCollection coll = this.getApplication().getActionCollection();
        session.addSeparatorToToolbar();
        session.addToToolbar(coll.get(AddBookmarkAction.class));
        session.addToToolbar(coll.get(EditBookmarksAction.class));
        this.initSqlPanel(session.getSessionInternalFrame().getMainSQLPanelAPI());
    }

    private void initSqlPanel(ISQLPanelAPI sqlPanelAPI) {
        ActionCollection coll = Main.getApplication().getActionCollection();
        sqlPanelAPI.addToToolsPopUp("bookmarkadd", coll.get(AddBookmarkAction.class));
        sqlPanelAPI.addToToolsPopUp("bookmarkedit", coll.get(EditBookmarksAction.class));
        sqlPanelAPI.addToToolsPopUp("bookmarkselect", (Action)((Object)this.registerBookmarkSelectKeyStroke(sqlPanelAPI)));
    }

    private CompleteBookmarkAction registerBookmarkSelectKeyStroke(ISQLPanelAPI sqlPaneAPI) {
        CompleteBookmarkAction cba = new CompleteBookmarkAction(Main.getApplication(), this._resources, sqlPaneAPI.getSQLEntryPanel(), this);
        JMenuItem item = sqlPaneAPI.addToSQLEntryAreaMenu((Action)((Object)cba));
        this._resources.configureMenuItem((Action)((Object)cba), item);
        JTextArea comp = sqlPaneAPI.getSQLEntryPanel().getTextComponent();
        comp.registerKeyboardAction((ActionListener)((Object)cba), this._resources.getKeyStroke((Action)((Object)cba)), 1);
        return cba;
    }

    protected void rebuildMenu() {
        ActionCollection coll = this.getApplication().getActionCollection();
        this.menu.removeAll();
        this._resources.addToMenu(coll.get(AddBookmarkAction.class), this.menu);
        this.menu.add(new JSeparator());
        Iterator<Bookmark> i = this.bookmarkManager.iterator();
        while (i.hasNext()) {
            Bookmark o;
            Bookmark bookmark = o = i.next();
            this.addBookmarkItem(bookmark);
        }
        String defaultMarksInPopup = this.getBookmarkProperties().getProperty(BOOKMARK_PROP_DEFAULT_MARKS_IN_POPUP, "false");
        if (Boolean.valueOf(defaultMarksInPopup).booleanValue()) {
            Bookmark[] defaultBookmarks = DefaultBookmarksFactory.getDefaultBookmarks();
            for (int i2 = 0; i2 < defaultBookmarks.length; ++i2) {
                this.addBookmarkItem(defaultBookmarks[i2]);
            }
        }
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        this.menu = this._resources.createMenu("bookmarks");
        app.addToMenu(2, this.menu);
    }

    protected void addBookmarkItem(Bookmark bookmark) {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenuItem item = new JMenuItem(coll.get(RunBookmarkAction.class));
        item.setText(bookmark.getName());
        this.menu.add(item);
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[]{new SQLBookmarkPreferencesController(this)};
    }

    public void addSQLPanelAPIListeningForBookmarks(ISQLPanelAPI sqlApi) {
        if (!this._sqlPanelAPIsListeningForBookmarks.contains(sqlApi)) {
            this._sqlPanelAPIsListeningForBookmarks.add(sqlApi);
        }
    }

    public void removeSQLPanelAPIListeningForBookmarks(ISQLPanelAPI sqlApi) {
        this._sqlPanelAPIsListeningForBookmarks.remove(sqlApi);
    }

    public void removeALLSQLPanelsAPIListeningForBookmarks() {
        this._sqlPanelAPIsListeningForBookmarks = new ArrayList();
    }

    public ISQLPanelAPI[] getSQLPanelAPIsListeningForBookmarks() {
        return this._sqlPanelAPIsListeningForBookmarks.toArray(new ISQLPanelAPI[this._sqlPanelAPIsListeningForBookmarks.size()]);
    }

    Properties getBookmarkProperties() {
        FileInputStream fis = null;
        try {
            Object usf;
            if (null == this._boomarkProps) {
                usf = this.getPluginUserSettingsFolder();
                FileWrapper boomarkPropsFile = this.fileWrapperFactory.create(usf, BOOKMARKS_PROPS_FILE);
                if (!boomarkPropsFile.exists()) {
                    this._boomarkProps = new Properties();
                } else {
                    fis = boomarkPropsFile.getFileInputStream();
                    this._boomarkProps = new Properties();
                    this._boomarkProps.load(fis);
                }
            }
            usf = this._boomarkProps;
            return usf;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    s_log.error((Object)("Unable to close output stream: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    void saveBookmarkProperties() {
        FileOutputStream fos = null;
        try {
            if (null == this._boomarkProps) {
                return;
            }
            FileWrapper usf = this.getPluginUserSettingsFolder();
            FileWrapper boomarkPropsFile = this.fileWrapperFactory.create(usf, BOOKMARKS_PROPS_FILE);
            fos = boomarkPropsFile.getFileOutputStream();
            this._boomarkProps.store(fos, "Bookmark properties");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    s_log.error((Object)("Unable to close output stream: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    private static interface IMenuResourceKeys {
        public static final String BOOKMARKS = "bookmarks";
    }
}

