/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCTemporalEscapeParse {
    private String _hql;
    private TreeMap<String, Date> _datesByParamName = new TreeMap();
    private TemporalData[] _temporalDatas = new TemporalData[]{new TimeStampData(), new DateData(), new TimeData()};

    public JDBCTemporalEscapeParse(String hql) {
        this._hql = hql;
        block0: for (TemporalData temporalData : this._temporalDatas) {
            Matcher matcher = temporalData.getPattern().matcher(this._hql);
            int startIx = 0;
            while (matcher.find(startIx)) {
                if (JDBCTemporalEscapeParse.isInLiteral(matcher.start(), this._hql)) {
                    startIx = matcher.start() + 1;
                    if (startIx < this._hql.length()) continue;
                    continue block0;
                }
                Date date = temporalData.valueOf(matcher.group(1));
                String paramName = "p" + this._datesByParamName.size();
                this._hql = this._hql.substring(0, matcher.start()) + ":" + paramName + this._hql.substring(matcher.end());
                this._datesByParamName.put(paramName, date);
                matcher = temporalData.getPattern().matcher(this._hql);
            }
        }
    }

    private static boolean isInLiteral(int pos, String str) {
        int countLiteralDelims = 0;
        for (int i = 0; i < pos; ++i) {
            if ('\'' != str.charAt(i)) continue;
            ++countLiteralDelims;
        }
        return 1 == countLiteralDelims % 2;
    }

    public String getMessagePanelInfoText() {
        String ret = "   " + this._hql;
        for (String paramName : this._datesByParamName.keySet()) {
            ret = ret + "\n   " + paramName + "=" + this._datesByParamName.get(paramName);
        }
        return ret;
    }

    public boolean hasEscapes() {
        return 0 < this._datesByParamName.size();
    }

    public String getHql() {
        return this._hql;
    }

    public TreeMap<String, Date> getDatesByParamName() {
        return this._datesByParamName;
    }

    public static void main(String[] args) {
        JDBCTemporalEscapeParse jep = new JDBCTemporalEscapeParse("dfd {ts '2012-03-08 19:52:21'} sdfdss d  'asdfs  {t '20:29:34'}' select  {d '2012-03-08'}  ");
        System.out.println(jep.getHql());
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
        jep = new JDBCTemporalEscapeParse("'{t '20:29:34'}'");
        System.out.println(jep.getHql());
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
        jep = new JDBCTemporalEscapeParse("{t '20:29:34'}");
        System.out.println(jep.getHql());
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
        jep = new JDBCTemporalEscapeParse("'{t '20:29:34'}'{t '20:29:34'}");
        System.out.println(jep.getHql());
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
        jep = new JDBCTemporalEscapeParse("{t '20:29:34'}'{t '20:29:34'}'");
        System.out.println(jep.getHql());
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
        jep = new JDBCTemporalEscapeParse("dfd {ts '2012-03-08 19:52:21'} sdfdss d  'asdfs  {t '20:29:34'}'  select  {t '20:29:34'} {d '2012-03-08'}  ");
        System.out.println(jep.getHql());
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
        jep = new JDBCTemporalEscapeParse("dfd {ts '2012-03-08 19:52:21'} sdfdss d  'asdfs  '  select  {t '20:29:34'} {d '2012-03-08'}  ");
        System.out.println(jep.getHql());
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
        jep = new JDBCTemporalEscapeParse("dfd sdfdss d  'asdfs  {t '20:29:34'} '  select   ");
        System.out.println(">" + jep.getHql() + "<");
        for (Date date : jep.getDatesByParamName().values()) {
            System.out.println("   date = " + date);
        }
    }

    private static class TimeData
    implements TemporalData {
        private TimeData() {
        }

        @Override
        public Date valueOf(String str) {
            try {
                return Time.valueOf(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not interpret " + str + " as " + Time.class.getName(), e);
            }
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("\\{t\\s*'([0-9[:-][\\s][\\.]]+\\s*)'\\}");
        }
    }

    private static class DateData
    implements TemporalData {
        private DateData() {
        }

        @Override
        public Date valueOf(String str) {
            try {
                return java.sql.Date.valueOf(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not interpret " + str + " as " + java.sql.Date.class.getName(), e);
            }
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("\\{d\\s*'([0-9[:-][\\s][\\.]]+\\s*)'\\}");
        }
    }

    private static class TimeStampData
    implements TemporalData {
        private TimeStampData() {
        }

        @Override
        public Date valueOf(String str) {
            try {
                return Timestamp.valueOf(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not interpret " + str + " as " + Timestamp.class.getName(), e);
            }
        }

        @Override
        public Pattern getPattern() {
            return Pattern.compile("\\{ts\\s*'([0-9[:-][\\s][\\.]]+\\s*)'\\}");
        }
    }

    private static interface TemporalData {
        public Date valueOf(String var1);

        public Pattern getPattern();
    }
}

