/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;

public class ObjectResultTab
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectResultTab.class);
    JLabel lblHqlQuery;
    JButton btnClose;
    JTree treeTypes;
    JPanel pnlResults;
    JButton btnCopySql;

    public ObjectResultTab(HibernatePluginResources resource) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTopPanel(resource), "North");
        this.add((Component)this.createSplitPane(), "Center");
    }

    private JSplitPane createSplitPane() {
        this.treeTypes = new JTree(new DefaultMutableTreeNode());
        this.treeTypes.getSelectionModel().setSelectionMode(1);
        this.pnlResults = new JPanel(new GridLayout(1, 1));
        final JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.treeTypes), this.pnlResults);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                splitPane.setLastDividerLocation(ObjectResultTab.this.getWidth() / 2);
            }
        };
        SwingUtilities.invokeLater(runnable);
        return splitPane;
    }

    private JPanel createTopPanel(HibernatePluginResources resource) {
        JPanel ret = new JPanel(new BorderLayout());
        this.lblHqlQuery = new JLabel();
        ret.add((Component)this.lblHqlQuery, "Center");
        ret.add((Component)this.createButtonPanel(resource), "East");
        return ret;
    }

    private JPanel createButtonPanel(HibernatePluginResources resource) {
        JPanel ret = new JPanel(new GridLayout(1, 2, 3, 2));
        this.btnCopySql = new JButton(resource.getIcon("sqlcopy"));
        this.btnCopySql.setToolTipText(s_stringMgr.getString("ObjectResultTab.CopySqlToClip"));
        this.btnCopySql.setBorder(BorderFactory.createRaisedBevelBorder());
        ret.add(this.btnCopySql);
        this.btnClose = new JButton(resource.getIcon("close"));
        this.btnClose.setBorder(BorderFactory.createRaisedBevelBorder());
        ret.add(this.btnClose);
        return ret;
    }
}

