/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapRectifierWMSmenuAction
extends JosmAction {
    private final transient List<RectifierService> services = new ArrayList<RectifierService>();

    public MapRectifierWMSmenuAction() {
        super(I18n.tr("Rectified Image...", new Object[0]), "OLmarker", I18n.tr("Download Rectified Images From Various Services", new Object[0]), Shortcut.registerShortcut("imagery:rectimg", I18n.tr("Imagery: {0}", I18n.tr("Rectified Image...", new Object[0])), 65535, 5000), true);
        this.putValue("help", HelpUtil.ht("/Menu/Imagery"));
        this.services.add(new RectifierService("Metacarta Map Rectifier", "http://labs.metacarta.com/rectifier/", "http://labs.metacarta.com/rectifier/wms.cgi?id=__s__&srs=EPSG:4326&Service=WMS&Version=1.1.0&Request=GetMap&format=image/png&", "labs\\.metacarta\\.com/(?:.*?)(?:/|=)([0-9]+)(?:\\?|/|\\.|$)", "^[0-9]+$"));
        this.services.add(new RectifierService("Map Warper", "http://mapwarper.net/", "http://mapwarper.net/maps/wms/__s__?request=GetMap&version=1.1.1&styles=&format=image/png&srs=epsg:4326&exceptions=application/vnd.ogc.se_inimage&", "(?:mapwarper\\.net|warper\\.geothings\\.net)/(?:.*?)/([0-9]+)(?:\\?|/|\\.|$)", "^[0-9]+$"));
        this.services.add(new RectifierService(I18n.tr("Custom WMS Link", new Object[0]), "", "", "^\\s+$", ""));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Supported Rectifier Services:", new Object[0])), GBC.eol());
        JosmTextField josmTextField = new JosmTextField(30);
        String string = ClipboardUtils.getClipboardStringContent();
        string = string == null ? "" : string.trim();
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractButton abstractButton = null;
        for (RectifierService rectifierService : this.services) {
            object = new JRadioButton(rectifierService.name);
            if (abstractButton == null) {
                abstractButton = object;
            }
            if (!string.isEmpty() && josmTextField.getText().isEmpty() && (rectifierService.urlRegEx.matcher(string).find() || rectifierService.idValidator.matcher(string).matches())) {
                ((AbstractButton)object).setSelected(true);
                josmTextField.setText(string);
            }
            rectifierService.btn = (JRadioButton)object;
            buttonGroup.add((AbstractButton)object);
            if (!rectifierService.url.isEmpty()) {
                jPanel.add((Component)object, GBC.std());
                jPanel.add((Component)new UrlLabel(rectifierService.url, I18n.tr("Visit Homepage", new Object[0])), GBC.eol().anchor(13));
                continue;
            }
            jPanel.add((Component)object, GBC.eol().anchor(17));
        }
        if (josmTextField.getText().isEmpty() && abstractButton != null) {
            abstractButton.setSelected(true);
        }
        jPanel.add((Component)new JLabel(I18n.tr("WMS URL or Image ID:", new Object[0])), GBC.eol());
        jPanel.add((Component)josmTextField, GBC.eol().fill(2));
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Add Rectified Image", new Object[0]), I18n.tr("Add Rectified Image", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(jPanel).setButtonIcons("OLmarker", "cancel");
        block3: while (true) {
            extendedDialog.showDialog();
            int n = extendedDialog.getValue();
            if (n != 1) break;
            object = josmTextField.getText().trim();
            for (RectifierService rectifierService : this.services) {
                Matcher matcher;
                if (!rectifierService.isSelected()) continue;
                if (rectifierService.wmsUrl.isEmpty()) {
                    try {
                        MapRectifierWMSmenuAction.addWMSLayer(rectifierService.name + " (" + (String)object + ')', (String)object);
                        break block3;
                    }
                    catch (IllegalStateException illegalStateException) {
                        Main.error((Throwable)illegalStateException, false);
                    }
                }
                if ((matcher = rectifierService.urlRegEx.matcher((CharSequence)object)).find()) {
                    String string2 = matcher.group(1);
                    String string3 = rectifierService.wmsUrl.replaceAll("__s__", string2);
                    String string4 = rectifierService.name + " (" + string2 + ')';
                    MapRectifierWMSmenuAction.addWMSLayer(string4, string3);
                    break block3;
                }
                if (!rectifierService.idValidator.matcher((CharSequence)object).matches()) break;
                String string5 = rectifierService.wmsUrl.replaceAll("__s__", (String)object);
                String string6 = rectifierService.name + " (" + (String)object + ')';
                MapRectifierWMSmenuAction.addWMSLayer(string6, string5);
                break block3;
            }
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Couldn''t match the entered link or id to the selected service. Please try again.", new Object[0]), I18n.tr("No valid WMS URL or id", new Object[0]), 0);
            extendedDialog.setVisible(true);
        }
    }

    private static void addWMSLayer(String string, String string2) {
        WMSLayer wMSLayer = new WMSLayer(new ImageryInfo(string, string2));
        Main.getLayerManager().addLayer(wMSLayer);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!Main.getLayerManager().getLayers().isEmpty());
    }

    public static class RectifierService {
        private final String name;
        private final String url;
        private final String wmsUrl;
        private final Pattern urlRegEx;
        private final Pattern idValidator;
        private JRadioButton btn;

        public RectifierService(String string, String string2, String string3, String string4, String string5) {
            this.name = string;
            this.url = string2;
            this.wmsUrl = string3;
            this.urlRegEx = Pattern.compile(string4);
            this.idValidator = Pattern.compile(string5);
        }

        private boolean isSelected() {
            return this.btn.isSelected();
        }
    }
}

