/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadPrimitiveAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.datatransfer.OpenTransferHandler;
import org.openstreetmap.josm.gui.dialogs.MenuItemSearchDialog;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferenceListener;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WikiReader;

public final class GettingStarted
extends JPanel
implements ProxyPreferenceListener {
    private final LinkGeneral lg = new LinkGeneral("<html><style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1><h2 align=\"center\">" + I18n.tr("Downloading \"Message of the day\"", new Object[0]) + "</h2></html>");
    private String content = "";
    private boolean contentInitialized;
    private static final String STYLE = "<style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n";

    public GettingStarted() {
        super(new BorderLayout());
        this.lg.getInputMap(0).put(DownloadPrimitiveAction.SHORTCUT.getKeyStroke(), "none");
        this.lg.getInputMap(0).put(MenuItemSearchDialog.Action.SHORTCUT.getKeyStroke(), "none");
        this.lg.setTransferHandler(null);
        JScrollPane jScrollPane = new JScrollPane(this.lg);
        jScrollPane.setViewportBorder(new EmptyBorder(10, 100, 10, 100));
        this.add((Component)jScrollPane, "Center");
        this.getMOTD();
        this.setTransferHandler(new OpenTransferHandler());
    }

    private void getMOTD() {
        Thread thread = new Thread(() -> {
            if (!this.contentInitialized && Main.pref.getBoolean("help.displaymotd", true)) {
                try {
                    this.content = new MotdContent().updateIfRequiredString();
                    this.contentInitialized = true;
                    ProxyPreference.removeProxyPreferenceListener(this);
                }
                catch (IOException iOException) {
                    Main.warn((Throwable)iOException, I18n.tr("Failed to read MOTD. Exception was: {0}", iOException.toString()));
                    this.content = "<html><style type=\"text/css\">\nbody {font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center; }\n.icon {font-size: 0; }\n</style>\n<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1>\n<h2 align=\"center\">(" + I18n.tr("Message of the day not available", new Object[0]) + ")</h2></html>";
                    ProxyPreference.addProxyPreferenceListener(this);
                }
            }
            if (this.content != null) {
                EventQueue.invokeLater(() -> this.lg.setText(GettingStarted.fixImageLinks(this.content)));
            }
        }, "MOTD-Loader");
        thread.setDaemon(true);
        thread.start();
    }

    static String fixImageLinks(String string) {
        Matcher matcher = Pattern.compile("src=\"/browser/trunk(/images/.*?\\.png)\\?format=raw\"").matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            URL uRL = GettingStarted.class.getResource(string2);
            if (uRL == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement("src=\"" + uRL + '\"'));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void proxyPreferenceChanged() {
        this.getMOTD();
    }

    static class MotdContent
    extends CacheCustomContent<IOException> {
        private final int myVersion = Version.getInstance().getVersion();
        private final String myJava = System.getProperty("java.version");
        private final String myLang = LanguageInfo.getWikiLanguagePrefix();

        MotdContent() {
            super("motd.html", CacheCustomContent.INTERVAL_DAILY);
        }

        @Override
        protected byte[] updateData() throws IOException {
            String string = new WikiReader().readLang("StartupPage");
            Main.pref.putInteger("cache.motd.html.version", this.myVersion);
            Main.pref.put("cache.motd.html.java", this.myJava);
            Main.pref.put("cache.motd.html.lang", this.myLang);
            return string.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected void checkOfflineAccess() {
            OnlineResource.JOSM_WEBSITE.checkOfflineAccess(new WikiReader().getBaseUrlWiki(), Main.getJOSMWebsite());
        }

        @Override
        protected boolean isCacheValid() {
            return Main.pref.getInteger("cache.motd.html.version", -999) == this.myVersion && Main.pref.get("cache.motd.html.java").equals(this.myJava) && Main.pref.get("cache.motd.html.lang").equals(this.myLang);
        }
    }

    public static class LinkGeneral
    extends JosmEditorPane
    implements HyperlinkListener {
        public LinkGeneral(String string) {
            this.setContentType("text/html");
            this.setText(string);
            this.setEditable(false);
            this.setOpaque(false);
            this.addHyperlinkListener(this);
            LinkGeneral.adaptForNimbus(this);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.displayUrl(hyperlinkEvent.getDescription());
            }
        }
    }
}

