/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.pdf.PDFAlphaDelayQueue;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFCycleDelayQueue;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFFontTable;
import org.freehep.graphicsio.pdf.PDFImageDelayQueue;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFOutline;
import org.freehep.graphicsio.pdf.PDFOutlineList;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFPaintDelayQueue;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;
import org.freehep.graphicsio.pdf.PDFWriter;

public class YPDFGraphics2D
extends AbstractVectorGraphicsIO
implements MultiPageDocument,
FontUtilities.ShowString {
    private static final String rootKey = YPDFGraphics2D.class.getName();
    public static final String VERSION6 = "Acrobat Reader 6.x";
    public static final String VERSION5 = "Acrobat Reader 5.x";
    public static final String VERSION4 = "Acrobat Reader 4.x";
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String PAGE_SIZE = rootKey + "." + "PageSize";
    public static final String PAGE_MARGINS = rootKey + "." + "PageMargins";
    public static final String ORIENTATION = rootKey + "." + "Orientation";
    public static final String FIT_TO_PAGE = rootKey + "." + "FitToPage";
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    public static final String EMBED_FONTS_AS = rootKey + "." + "EmbedFontsAs";
    public static final String THUMBNAILS = rootKey + ".Thumbnails";
    public static final String THUMBNAIL_SIZE = rootKey + ".ThumbnailSize";
    public static final String COMPRESS = rootKey + ".Compress";
    public static final String VERSION = rootKey + ".Version";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    public static final String AUTHOR = rootKey + "." + "Author";
    public static final String TITLE = rootKey + "." + "Title";
    public static final String SUBJECT = rootKey + "." + "Subject";
    public static final String KEYWORDS = rootKey + "." + "Keywords";
    public static final String PREFERRED_PAGE_SIZE = rootKey + ".PreferredPageSize";
    public static final String DEFAULT_PAINT = rootKey + ".DefaultPaint";
    private static final UserProperties defaultProperties = new UserProperties();
    private static final String PDF_VERSION = "1.4";
    private static final String[] COMPRESS_FILTERS;
    private static final String[] NO_FILTERS;
    private static final double FONTSIZE_CORRECTION = 1.0;
    private static final int PATTERN_ALPHA = 1;
    private static final int PATTERN_CYCLE = 2;
    private OutputStream ros;
    private PDFWriter os;
    private PDFStream pageStream;
    private PDFFontTable fontTable;
    private PDFImageDelayQueue delayImageQueue;
    private AffineTransform initialTransform;
    private PDFPaintDelayQueue delayPaintQueue;
    private PDFAlphaDelayQueue delayAlphaQueue;
    private PDFCycleDelayQueue delayCycleQueue;
    private int currentPage;
    private boolean multiPage;
    private boolean outlinesEnabled;
    private TagString[] headerText;
    private int headerUnderline;
    private Font headerFont;
    private TagString[] footerText;
    private int footerUnderline;
    private Font footerFont;
    private List titles;
    Map extGStates;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties properties) {
        defaultProperties.setProperties(properties);
    }

    public YPDFGraphics2D(File file, Dimension dimension) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), dimension);
    }

    public YPDFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public YPDFGraphics2D(OutputStream outputStream, Dimension dimension) {
        super(dimension, false);
        this.init(outputStream);
    }

    public YPDFGraphics2D(OutputStream outputStream, Component component) {
        super(component, false);
        this.init(outputStream);
    }

    private void init(OutputStream outputStream) {
        this.ros = new BufferedOutputStream(outputStream);
        this.initialTransform = this.getTransform();
        this.currentPage = 0;
        this.multiPage = false;
        this.titles = new ArrayList();
        this.initProperties(defaultProperties);
    }

    protected YPDFGraphics2D(YPDFGraphics2D yPDFGraphics2D, boolean bl) {
        super(yPDFGraphics2D, bl);
        this.os = yPDFGraphics2D.os;
        this.pageStream = yPDFGraphics2D.pageStream;
        this.delayImageQueue = yPDFGraphics2D.delayImageQueue;
        this.delayPaintQueue = yPDFGraphics2D.delayPaintQueue;
        this.delayAlphaQueue = yPDFGraphics2D.delayAlphaQueue;
        this.delayCycleQueue = yPDFGraphics2D.delayCycleQueue;
        this.fontTable = yPDFGraphics2D.fontTable;
        this.currentPage = yPDFGraphics2D.currentPage;
        this.multiPage = yPDFGraphics2D.multiPage;
        this.titles = yPDFGraphics2D.titles;
        this.extGStates = yPDFGraphics2D.extGStates;
        this.initialTransform = yPDFGraphics2D.getTransform();
    }

    public void setMultiPage(boolean bl) {
        this.multiPage = bl;
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    public void setOutlinesEnabled(boolean bl) {
        this.outlinesEnabled = bl;
    }

    public boolean isOutlinesEnabled() {
        return this.outlinesEnabled;
    }

    public static void setClipEnabled(boolean bl) {
        defaultProperties.setProperty(CLIP, bl);
    }

    public void writeHeader() throws IOException {
        Object object;
        this.os = new PDFWriter(new BufferedOutputStream(this.ros), PDF_VERSION);
        this.delayImageQueue = new PDFImageDelayQueue(this.os);
        this.delayPaintQueue = new PDFPaintDelayQueue(this.os, this.delayImageQueue);
        this.delayAlphaQueue = new PDFAlphaDelayQueue(this.os);
        this.delayCycleQueue = new PDFCycleDelayQueue(this.os);
        this.fontTable = new PDFFontTable(this.os);
        String string = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            string = string + " 1.5";
        }
        PDFDocInfo pDFDocInfo = this.os.openDocInfo("DocInfo");
        pDFDocInfo.setTitle(this.getProperty(TITLE));
        pDFDocInfo.setAuthor(this.getProperty(AUTHOR));
        pDFDocInfo.setSubject(this.getProperty(SUBJECT));
        pDFDocInfo.setKeywords(this.getProperty(KEYWORDS));
        pDFDocInfo.setCreator(this.getCreator());
        pDFDocInfo.setProducer(string);
        if (!this.isDeviceIndependent()) {
            object = Calendar.getInstance();
            pDFDocInfo.setCreationDate((Calendar)object);
            pDFDocInfo.setModificationDate((Calendar)object);
        }
        pDFDocInfo.setTrapped("False");
        this.os.close(pDFDocInfo);
        object = this.os.openCatalog("Catalog", "RootPage");
        if (this.isOutlinesEnabled()) {
            ((PDFCatalog)object).setOutlines("Outlines");
            ((PDFCatalog)object).setPageMode("UseOutlines");
        }
        ((PDFCatalog)object).setViewerPreferences("Preferences");
        ((PDFCatalog)object).setOpenAction(new Object[]{this.os.ref("Page1"), this.os.name("Fit")});
        this.os.close((PDFCatalog)object);
        PDFViewerPreferences pDFViewerPreferences = this.os.openViewerPreferences("Preferences");
        pDFViewerPreferences.setFitWindow(true);
        pDFViewerPreferences.setCenterWindow(false);
        this.os.close(pDFViewerPreferences);
        this.extGStates = new HashMap();
        if (!this.isMultiPage()) {
            this.openPage(this.getSize(), null, this.getComponent());
        }
    }

    public void writeBackground() {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        PDFDictionary pDFDictionary;
        String string;
        Object object;
        PDFDictionary pDFDictionary2;
        int n;
        if (!this.isMultiPage()) {
            this.closePage();
        }
        PDFPageTree pDFPageTree = this.os.openPageTree("RootPage", null);
        for (int i = 1; i <= this.currentPage; ++i) {
            pDFPageTree.addPage("Page" + i);
        }
        Dimension dimension = this.getPageSize();
        pDFPageTree.setMediaBox(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        pDFPageTree.setResources("Resources");
        this.os.close(pDFPageTree);
        this.os.object("PageProcSet", new Object[]{this.os.name("PDF"), this.os.name("Text"), this.os.name("ImageC")});
        int n2 = this.fontTable.addFontDictionary();
        int n3 = this.delayImageQueue.addXObjects();
        if (this.delayCycleQueue.isEmpty()) {
            n = this.delayPaintQueue.addPatterns();
        } else {
            pDFDictionary2 = this.os.openDictionary("Pattern");
            n = this.delayPaintQueue.addPatterns(pDFDictionary2);
            this.delayCycleQueue.addCycles(pDFDictionary2);
            this.os.close(pDFDictionary2);
        }
        this.delayAlphaQueue.writeTransparencyGroups(this.isProperty(COMPRESS) ? COMPRESS_FILTERS : NO_FILTERS);
        if (this.extGStates.size() > 0 || !this.delayAlphaQueue.isEmpty()) {
            pDFDictionary2 = this.os.openDictionary("ExtGState");
            object = this.extGStates.keySet().iterator();
            while (object.hasNext()) {
                Float f = (Float)object.next();
                string = (String)this.extGStates.get(f);
                pDFDictionary = pDFDictionary2.openDictionary(string);
                pDFDictionary.entry("ca", f.floatValue());
                pDFDictionary.entry("CA", f.floatValue());
                pDFDictionary.entry("BM", this.os.name("Normal"));
                pDFDictionary.entry("AIS", false);
                pDFDictionary2.close(pDFDictionary);
            }
            this.delayAlphaQueue.writeSoftMasks(pDFDictionary2);
            this.os.close(pDFDictionary2);
        }
        pDFDictionary2 = this.os.openDictionary("Resources");
        pDFDictionary2.entry("ProcSet", this.os.ref("PageProcSet"));
        if (n2 > 0) {
            pDFDictionary2.entry("Font", this.os.ref("FontList"));
        }
        if (n3 > 0) {
            pDFDictionary2.entry("XObject", this.os.ref("XObjects"));
        }
        if (n > 0 || !this.delayCycleQueue.isEmpty()) {
            pDFDictionary2.entry("Pattern", this.os.ref("Pattern"));
        }
        if (this.extGStates.size() > 0 || !this.delayAlphaQueue.isEmpty()) {
            pDFDictionary2.entry("ExtGState", this.os.ref("ExtGState"));
        }
        this.os.close(pDFDictionary2);
        if (this.isOutlinesEnabled()) {
            object = this.os.openOutlineList("Outlines", "Outline1", "Outline" + this.currentPage);
            this.os.close((PDFOutlineList)object);
            for (int i = 1; i <= this.currentPage; ++i) {
                string = i > 1 ? "Outline" + (i - 1) : null;
                pDFDictionary = i < this.currentPage ? "Outline" + (i + 1) : null;
                PDFOutline pDFOutline = this.os.openOutline("Outline" + i, (String)this.titles.get(i - 1), "Outlines", string, (String)((Object)pDFDictionary));
                pDFOutline.setDest(new Object[]{this.os.ref("Page" + i), this.os.name("Fit")});
                this.os.close(pDFOutline);
            }
        }
        this.processDelayed();
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    private void processDelayed() throws IOException {
        this.delayImageQueue.processAll();
        this.delayPaintQueue.processAll();
        this.delayCycleQueue.writeCycles();
        this.fontTable.embedAll(this.getFontRenderContext(), this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
    }

    public void openPage(Component component) throws IOException {
        this.openPage(component.getSize(), component.getName(), component);
    }

    public void openPage(Dimension dimension, String string) throws IOException {
        this.openPage(dimension, string, null);
    }

    private void openPage(Dimension dimension, String string, Component component) throws IOException {
        Object object;
        if (dimension == null) {
            dimension = component.getSize();
        }
        this.resetClip(new Rectangle(0, 0, dimension.width, dimension.height));
        if (this.pageStream != null) {
            this.writeWarning("Page " + this.currentPage + " already open. Call closePage() before starting a new one.");
            return;
        }
        BufferedImage bufferedImage = null;
        if (component != null && this.isProperty(THUMBNAILS)) {
            bufferedImage = ImageGraphics2D.generateThumbnail(component, this.getPropertyDimension(THUMBNAIL_SIZE));
        }
        ++this.currentPage;
        if (string == null) {
            string = "Page " + this.currentPage + " (untitled)";
        }
        this.titles.add(string);
        PDFPage pDFPage = this.os.openPage("Page" + this.currentPage, "RootPage");
        pDFPage.setContents("PageContents" + this.currentPage);
        if (bufferedImage != null) {
            pDFPage.setThumb("Thumb" + this.currentPage);
        }
        this.os.close(pDFPage);
        if (bufferedImage != null) {
            object = this.os.openStream("Thumb" + this.currentPage);
            ((PDFStream)object).image(bufferedImage, Color.black, "ZLIB");
            this.os.close((PDFStream)object);
        }
        this.pageStream = this.os.openStream("PageContents" + this.currentPage, this.isProperty(COMPRESS) ? COMPRESS_FILTERS : NO_FILTERS);
        object = new AffineTransform();
        ((AffineTransform)object).scale(1.0, -1.0);
        Dimension dimension2 = this.getPageSize();
        Insets insets = PageConstants.getMargins(this.getPropertyInsets(PAGE_MARGINS), this.getProperty(ORIENTATION));
        ((AffineTransform)object).translate(insets.left, -(dimension2.getHeight() - (double)insets.top));
        this.writeHeadline((AffineTransform)object);
        this.writeFootline((AffineTransform)object);
        double d = Math.min(this.getWidth() / (double)dimension.width, this.getHeight() / (double)dimension.height);
        if (d < 1.0 || this.isProperty(FIT_TO_PAGE)) {
            ((AffineTransform)object).scale(d, d);
        } else {
            d = 1.0;
        }
        double d2 = (this.getWidth() - (double)dimension.width * d) / 2.0 / d;
        double d3 = (this.getHeight() - (double)dimension.height * d) / 2.0 / d;
        ((AffineTransform)object).translate(d2, d3);
        this.writeTransform((AffineTransform)object);
        this.writeGraphicsSave();
        this.clipRect(0, 0, dimension.width, dimension.height);
        this.writeGraphicsSave();
        this.delayPaintQueue.setPageMatrix((AffineTransform)object);
        this.delayCycleQueue.setPageMatrix((AffineTransform)object);
        this.writeGraphicsState();
        this.writeBackground();
    }

    public void closePage() throws IOException {
        if (this.pageStream == null) {
            this.writeWarning("Page " + this.currentPage + " already closed. Call openPage() to start a new one.");
            return;
        }
        this.writeGraphicsRestore();
        this.writeGraphicsRestore();
        this.os.close(this.pageStream);
        this.pageStream = null;
        this.processDelayed();
    }

    public void setHeader(Font font, TagString tagString, TagString tagString2, TagString tagString3, int n) {
        this.headerFont = font;
        this.headerText = new TagString[3];
        this.headerText[0] = tagString;
        this.headerText[1] = tagString2;
        this.headerText[2] = tagString3;
        this.headerUnderline = n;
    }

    public void setFooter(Font font, TagString tagString, TagString tagString2, TagString tagString3, int n) {
        this.footerFont = font;
        this.footerText = new TagString[3];
        this.footerText[0] = tagString;
        this.footerText[1] = tagString2;
        this.footerText[2] = tagString3;
        this.footerUnderline = n;
    }

    private void writeHeadline(AffineTransform affineTransform) throws IOException {
        if (this.headerText != null) {
            LineMetrics lineMetrics = this.headerFont.getLineMetrics("mM", this.getFontRenderContext());
            this.writeLine(affineTransform, this.headerFont, this.headerText, -lineMetrics.getLeading() - this.headerFont.getSize2D() / 2.0f, 3, -this.headerFont.getSize2D() / 2.0f, this.headerUnderline);
        }
    }

    private void writeFootline(AffineTransform affineTransform) throws IOException {
        if (this.footerText != null) {
            LineMetrics lineMetrics = this.footerFont.getLineMetrics("mM", this.getFontRenderContext());
            double d = this.getHeight() + (double)(this.footerFont.getSize2D() / 2.0f);
            this.writeLine(affineTransform, this.footerFont, this.footerText, d + (double)lineMetrics.getLeading(), 1, d, this.footerUnderline);
        }
    }

    private void writeLine(AffineTransform affineTransform, Font font, TagString[] tagStringArray, double d, int n, double d2, int n2) throws IOException {
        this.writeGraphicsSave();
        this.setColor(Color.black);
        this.setFont(font);
        this.writeTransform(affineTransform);
        if (tagStringArray[0] != null) {
            this.drawString(tagStringArray[0], 0.0, d, 1, n);
        }
        if (tagStringArray[1] != null) {
            this.drawString(tagStringArray[1], this.getWidth() / 2.0, d, 2, n);
        }
        if (tagStringArray[2] != null) {
            this.drawString(tagStringArray[2], this.getWidth(), d, 3, n);
        }
        if (n2 >= 0) {
            this.setLineWidth((double)n2);
            this.drawLine(0.0, d2, this.getWidth(), d2);
        }
        this.writeGraphicsRestore();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return new YPDFGraphics2D(this, true);
    }

    public Graphics create(double d, double d2, double d3, double d4) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        YPDFGraphics2D yPDFGraphics2D = new YPDFGraphics2D(this, true);
        yPDFGraphics2D.translate(d, d2);
        yPDFGraphics2D.clipRect(0.0, 0.0, d3, d4);
        return yPDFGraphics2D;
    }

    protected void writeGraphicsSave() throws IOException {
        this.pageStream.save();
    }

    protected void writeGraphicsRestore() throws IOException {
        this.pageStream.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Shape shape) {
        block9: {
            try {
                int n = this.checkPattern();
                if (n == 0) {
                    this.drawCore(shape);
                    break block9;
                }
                this.writeGraphicsSave();
                try {
                    if ((n & 2) == 2) {
                        this.writeCyclePattern(shape.getBounds());
                    }
                    if ((n & 1) == 1) {
                        Shape shape2 = this.getStroke().createStrokedShape(shape);
                        this.writeAlphaPattern(shape2.getBounds());
                        this.pageStream.drawPath(shape2);
                        this.pageStream.fill();
                    } else {
                        this.drawCore(shape);
                    }
                }
                finally {
                    this.writeGraphicsRestore();
                }
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
    }

    private void drawCore(Shape shape) throws IOException {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            this.pageStream.drawPath(shape);
            this.pageStream.stroke();
        } else {
            this.pageStream.drawPath(stroke.createStrokedShape(shape));
            this.pageStream.fill();
        }
    }

    public void fill(Shape shape) {
        block8: {
            try {
                int n = this.checkPattern();
                if (n == 0) {
                    this.fillCore(shape);
                    break block8;
                }
                this.writeGraphicsSave();
                try {
                    if ((n & 2) == 2) {
                        this.writeCyclePattern(shape.getBounds());
                    }
                    if ((n & 1) == 1) {
                        this.writeAlphaPattern(shape.getBounds());
                    }
                    this.fillCore(shape);
                }
                finally {
                    this.writeGraphicsRestore();
                }
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
    }

    private void fillCore(Shape shape) throws IOException {
        boolean bl = this.pageStream.drawPath(shape);
        if (bl) {
            this.pageStream.fillEvenOdd();
        } else {
            this.pageStream.fill();
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage renderedImage, AffineTransform affineTransform, Color color) throws IOException {
        PDFName pDFName = this.delayImageQueue.delayImage(renderedImage, color, this.getProperty(WRITE_IMAGES_AS));
        AffineTransform affineTransform2 = new AffineTransform((double)renderedImage.getWidth(), 0.0, 0.0, (double)(-renderedImage.getHeight()), 0.0, (double)renderedImage.getHeight());
        affineTransform.concatenate(affineTransform2);
        this.writeGraphicsSave();
        this.pageStream.matrix(affineTransform);
        this.pageStream.xObject(pDFName);
        this.writeGraphicsRestore();
    }

    protected void writeString(String string, double d, double d2) throws IOException {
        this.writeGraphicsSave();
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, d, d2);
        affineTransform.concatenate(this.getFont().getTransform());
        affineTransform.scale(1.0, -1.0);
        this.writeTransform(affineTransform);
        this.pageStream.beginText();
        this.pageStream.text(0.0, 0.0);
        this.showCharacterCodes(string);
        this.pageStream.endText();
        this.writeGraphicsRestore();
    }

    protected void writeTransform(AffineTransform affineTransform) throws IOException {
        this.pageStream.matrix(affineTransform);
    }

    protected void writeSetClip(Shape shape) throws IOException {
        try {
            AffineTransform affineTransform = this.getTransform();
            Stroke stroke = this.getStroke();
            Paint paint = this.getPaint();
            this.writeGraphicsRestore();
            this.writeGraphicsSave();
            this.resetPaint(paint);
            this.resetStroke(stroke);
            this.resetTransform(affineTransform);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.handleException(noninvertibleTransformException);
        }
        this.writeClip(shape);
    }

    private void resetTransform(AffineTransform affineTransform) throws NoninvertibleTransformException, IOException {
        AffineTransform affineTransform2 = this.initialTransform.createInverse();
        affineTransform2.concatenate(affineTransform);
        this.writeTransform(affineTransform2);
    }

    private void resetStroke(Stroke stroke) throws IOException {
        this.writeStroke(stroke);
    }

    private void resetPaint(Paint paint) throws IOException {
        if (paint instanceof Color) {
            this.writePaint(this.getPrintColor((Color)paint));
        } else if (paint instanceof GradientPaint) {
            this.writePaint((GradientPaint)paint);
        } else if (paint instanceof TexturePaint) {
            this.writePaint((TexturePaint)paint);
        } else {
            this.writePaint(paint);
        }
    }

    protected void writeClip(Shape shape) throws IOException {
        if (shape == null || !this.isProperty(CLIP)) {
            return;
        }
        if (shape instanceof Rectangle2D) {
            this.pageStream.move(((Rectangle2D)shape).getMinX(), ((Rectangle2D)shape).getMinY());
            this.pageStream.line(((Rectangle2D)shape).getMaxX(), ((Rectangle2D)shape).getMinY());
            this.pageStream.line(((Rectangle2D)shape).getMaxX(), ((Rectangle2D)shape).getMaxY());
            this.pageStream.line(((Rectangle2D)shape).getMinX(), ((Rectangle2D)shape).getMaxY());
            this.pageStream.closePath();
            this.pageStream.clip();
            this.pageStream.endPath();
        } else {
            boolean bl = this.pageStream.drawPath(shape);
            if (bl) {
                this.pageStream.clipEvenOdd();
            } else {
                this.pageStream.clip();
            }
            this.pageStream.endPath();
        }
    }

    protected void writeWidth(float f) throws IOException {
        this.pageStream.width(f);
    }

    protected void writeCap(int n) throws IOException {
        switch (n) {
            default: {
                this.pageStream.cap(0);
                break;
            }
            case 1: {
                this.pageStream.cap(1);
                break;
            }
            case 2: {
                this.pageStream.cap(2);
            }
        }
    }

    protected void writeJoin(int n) throws IOException {
        switch (n) {
            default: {
                this.pageStream.join(0);
                break;
            }
            case 1: {
                this.pageStream.join(1);
                break;
            }
            case 2: {
                this.pageStream.join(2);
            }
        }
    }

    protected void writeMiterLimit(float f) throws IOException {
        this.pageStream.mitterLimit(f);
    }

    protected void writeDash(float[] fArray, float f) throws IOException {
        this.pageStream.dash(fArray, (double)f);
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color color) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color color) throws IOException {
        float[] fArray = color.getRGBComponents(null);
        this.writeAlpha(fArray[3]);
        this.pageStream.colorSpace(fArray[0], fArray[1], fArray[2]);
        this.pageStream.colorSpaceStroke(fArray[0], fArray[1], fArray[2]);
    }

    protected void writePaint(GradientPaint gradientPaint) throws IOException {
        this.writeAlpha(1.0f);
        if (gradientPaint.isCyclic()) {
            this.pageStream.colorSpace(this.os.name("Pattern"));
            this.pageStream.colorSpaceStroke(this.os.name("Pattern"));
        } else {
            this.writePaintImpl(gradientPaint);
        }
    }

    protected void writePaint(TexturePaint texturePaint) throws IOException {
        this.writeAlpha(1.0f);
        this.writePaintImpl(texturePaint);
    }

    protected void writePaint(Paint paint) throws IOException {
        this.writePaint(this.getPropertyColor(DEFAULT_PAINT));
    }

    private void writePaintImpl(Paint paint) throws IOException {
        this.pageStream.colorSpace(this.os.name("Pattern"));
        this.pageStream.colorSpaceStroke(this.os.name("Pattern"));
        PDFName pDFName = this.delayPaintQueue.delayPaint(paint, this.getTransform(), this.getProperty(WRITE_IMAGES_AS));
        this.pageStream.colorSpace(null, pDFName);
        this.pageStream.colorSpaceStroke(new double[0], pDFName);
    }

    protected void setNonStrokeColor(Color color) throws IOException {
        float[] fArray = color.getRGBColorComponents(null);
        this.pageStream.colorSpace(fArray[0], fArray[1], fArray[2]);
    }

    protected void setStrokeColor(Color color) throws IOException {
        float[] fArray = color.getRGBColorComponents(null);
        this.pageStream.colorSpaceStroke(fArray[0], fArray[1], fArray[2]);
    }

    protected void writeFont(Font font) throws IOException {
    }

    private void writeAlpha(float f) throws IOException {
        Float f2 = new Float(f);
        String string = (String)this.extGStates.get(f2);
        if (string == null) {
            string = "Alpha" + (this.extGStates.size() + 1);
            this.extGStates.put(f2, string);
        }
        this.pageStream.state(this.os.name(string));
    }

    private void writeAlphaPattern(Rectangle rectangle) throws IOException {
        this.pageStream.state(this.delayAlphaQueue.delayAlpha((GradientPaint)this.getPaint(), rectangle));
    }

    private void writeCyclePattern(Rectangle rectangle) throws IOException {
        PDFName pDFName = this.delayCycleQueue.delayCycle((GradientPaint)this.getPaint(), rectangle, this.getTransform());
        this.pageStream.colorSpace(null, pDFName);
        this.pageStream.colorSpaceStroke(null, pDFName);
    }

    private int checkPattern() {
        int n = 0;
        Paint paint = this.getPaint();
        if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            if (gradientPaint.getColor1().getAlpha() < 255 || gradientPaint.getColor2().getAlpha() < 255) {
                n |= 1;
            }
            if (gradientPaint.isCyclic()) {
                n |= 2;
            }
        }
        return n;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public void writeComment(String string) throws IOException {
    }

    public String toString() {
        return "YPDFGraphics2D";
    }

    public void showString(Font font, String string) throws IOException {
        String string2 = this.fontTable.fontReference(font, this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
        this.pageStream.font(this.os.name(string2), (double)font.getSize() * 1.0);
        this.pageStream.show(string);
    }

    private void showCharacterCodes(String string) throws IOException {
        FontUtilities.showString(this.getFont(), string, Lookup.getInstance().getTable("PDFLatin"), this);
    }

    private double getWidth() {
        Dimension dimension = this.getPageSize();
        Insets insets = PageConstants.getMargins(this.getPropertyInsets(PAGE_MARGINS), this.getProperty(ORIENTATION));
        return dimension.getWidth() - (double)insets.left - (double)insets.right;
    }

    private double getHeight() {
        Dimension dimension = this.getPageSize();
        Insets insets = PageConstants.getMargins(this.getPropertyInsets(PAGE_MARGINS), this.getProperty(ORIENTATION));
        return dimension.getHeight() - (double)insets.top - (double)insets.bottom;
    }

    private Dimension getPageSize() {
        Dimension dimension = this.getPropertyDimension(PREFERRED_PAGE_SIZE);
        if (dimension == null) {
            dimension = PageConstants.getSize(this.getProperty(PAGE_SIZE), this.getProperty(ORIENTATION));
        }
        return dimension;
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(VERSION, VERSION5);
        defaultProperties.setProperty(COMPRESS, false);
        defaultProperties.setProperty(PAGE_SIZE, "International");
        defaultProperties.setProperty(PAGE_MARGINS, PageConstants.getMargins("Small"));
        defaultProperties.setProperty(ORIENTATION, "Portrait");
        defaultProperties.setProperty(FIT_TO_PAGE, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(EMBED_FONTS_AS, "Type3");
        defaultProperties.setProperty(THUMBNAILS, defaultProperties.getProperty(VERSION).equals(VERSION4));
        defaultProperties.setProperty(THUMBNAIL_SIZE, new Dimension(128, 128));
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(AUTHOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(SUBJECT, "");
        defaultProperties.setProperty(KEYWORDS, "");
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        defaultProperties.setProperty(DEFAULT_PAINT, new Color(0, 0, 0, 0));
        COMPRESS_FILTERS = new String[]{"Flate", "ASCII85"};
        NO_FILTERS = new String[0];
    }
}

