/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.freehep.graphicsio.swf.DefineFontInfo;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFont
extends DefinitionTag {
    private int character;
    private List<SWFShape> shapes;
    private DefineFontInfo info;

    public DefineFont(int id) {
        this();
        this.character = id;
        this.shapes = new ArrayList<SWFShape>();
    }

    public void add(SWFShape shape) {
        this.shapes.add(shape);
    }

    public DefineFont() {
        super(10, 1);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        int i;
        DefineFont tag = new DefineFont();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        int offset0 = swf.readUnsignedShort();
        int glyphCount = offset0 / 2;
        int[] offsets = new int[glyphCount];
        offsets[0] = offset0;
        for (i = 1; i < glyphCount; ++i) {
            offsets[i] = swf.readUnsignedShort();
        }
        tag.shapes = new ArrayList<SWFShape>();
        for (i = 0; i < glyphCount; ++i) {
            tag.shapes.add(new SWFShape(swf));
        }
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        int i;
        swf.writeUnsignedShort(this.character);
        swf.pushBuffer();
        int[] offsets = new int[this.shapes.size()];
        for (i = 0; i < this.shapes.size(); ++i) {
            offsets[i] = swf.getBufferLength();
            this.shapes.get(i).write(swf);
        }
        swf.popBuffer();
        for (i = 0; i < this.shapes.size(); ++i) {
            swf.writeUnsignedShort(this.shapes.size() * 2 + offsets[i]);
        }
        swf.append();
    }

    public int getGlyphCount() {
        return this.shapes.size();
    }

    public void setFontInfo(DefineFontInfo info) {
        this.info = info;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  glyphcount: " + this.shapes.size() + "\n");
        for (int i = 0; i < this.shapes.size(); ++i) {
            s.append(this.shapes.get(i) + "\n");
        }
        s.append("  fontInfo: " + this.info + "\n");
        return s.toString();
    }
}

