/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.log4j.Logger;

public class DavMailIdleConnectionEvictor {
    static final Logger LOGGER = Logger.getLogger(DavMailIdleConnectionEvictor.class);
    private static final HashSet<HttpClientConnectionManager> connectionManagers = new HashSet();
    private static final long sleepTimeMs = 1000L;
    private static final long maxIdleTimeMs = 3000L;
    private static Thread thread;

    private static void initEvictorThread() {
        if (thread == null) {
            thread = new Thread(() -> {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.sleep(1000L);
                        HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
                        synchronized (hashSet) {
                            for (HttpClientConnectionManager connectionManager : connectionManagers) {
                                connectionManager.closeExpiredConnections();
                                connectionManager.closeIdleConnections(3000L, TimeUnit.MILLISECONDS);
                            }
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex);
                }
            }, "Connection evictor");
            thread.setDaemon(true);
        }
    }

    public static void shutdown() throws InterruptedException {
        thread.interrupt();
        thread.join(1000L);
        thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnectionManager(HttpClientConnectionManager connectionManager) {
        HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
        synchronized (hashSet) {
            DavMailIdleConnectionEvictor.initEvictorThread();
            connectionManagers.add(connectionManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionManager(HttpClientConnectionManager connectionManager) {
        HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
        synchronized (hashSet) {
            connectionManagers.remove(connectionManager);
        }
    }
}

