/*
 * Decompiled with CFR 0.152.
 */
package davmail.smtp;

import davmail.AbstractConnection;
import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.exception.DavMailException;
import davmail.exchange.DoubleDotInputStream;
import davmail.exchange.ExchangeSessionFactory;
import davmail.ui.tray.DavGatewayTray;
import davmail.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;

public class SmtpConnection
extends AbstractConnection {
    public SmtpConnection(Socket clientSocket) {
        super(SmtpConnection.class.getSimpleName(), clientSocket, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<String> recipients = new ArrayList<String>();
        try {
            String line;
            ExchangeSessionFactory.checkConfig();
            this.sendClient("220 DavMail " + DavGateway.getCurrentVersion() + " SMTP ready at " + new Date());
            while ((line = this.readClient()) != null) {
                StringTokenizer tokens = new StringTokenizer(line);
                if (tokens.hasMoreTokens()) {
                    String command = tokens.nextToken();
                    if (this.state == AbstractConnection.State.LOGIN) {
                        this.userName = IOUtil.decodeBase64AsString(line);
                        this.sendClient("334 " + IOUtil.encodeBase64AsString("Password:"));
                        this.state = AbstractConnection.State.PASSWORD;
                    } else if (this.state == AbstractConnection.State.PASSWORD) {
                        this.password = IOUtil.decodeBase64AsString(line);
                        this.authenticate();
                    } else {
                        if ("QUIT".equalsIgnoreCase(command)) {
                            this.sendClient("221 Closing connection");
                            break;
                        }
                        if ("NOOP".equalsIgnoreCase(command)) {
                            this.sendClient("250 OK");
                        } else if ("EHLO".equalsIgnoreCase(command)) {
                            this.sendClient("250-" + tokens.nextToken());
                            this.sendClient("250-AUTH LOGIN PLAIN");
                            this.sendClient("250-8BITMIME");
                            this.sendClient("250 Hello");
                        } else if ("HELO".equalsIgnoreCase(command)) {
                            this.sendClient("250 Hello");
                        } else if ("AUTH".equalsIgnoreCase(command)) {
                            if (tokens.hasMoreElements()) {
                                String authType = tokens.nextToken();
                                if ("PLAIN".equalsIgnoreCase(authType) && tokens.hasMoreElements()) {
                                    this.decodeCredentials(tokens.nextToken());
                                    this.authenticate();
                                } else if ("LOGIN".equalsIgnoreCase(authType)) {
                                    if (tokens.hasMoreTokens()) {
                                        this.userName = IOUtil.decodeBase64AsString(tokens.nextToken());
                                        this.sendClient("334 " + IOUtil.encodeBase64AsString("Password:"));
                                        this.state = AbstractConnection.State.PASSWORD;
                                    } else {
                                        this.sendClient("334 " + IOUtil.encodeBase64AsString("Username:"));
                                        this.state = AbstractConnection.State.LOGIN;
                                    }
                                } else {
                                    this.sendClient("451 Error : unknown authentication type");
                                }
                            } else {
                                this.sendClient("451 Error : authentication type not specified");
                            }
                        } else if ("MAIL".equalsIgnoreCase(command)) {
                            if (this.state == AbstractConnection.State.AUTHENTICATED) {
                                this.state = AbstractConnection.State.STARTMAIL;
                                recipients.clear();
                                this.sendClient("250 Sender OK");
                            } else if (this.state == AbstractConnection.State.INITIAL) {
                                this.sendClient("530 Authentication required");
                            } else {
                                this.state = AbstractConnection.State.INITIAL;
                                this.sendClient("503 Bad sequence of commands");
                            }
                        } else if ("RCPT".equalsIgnoreCase(command)) {
                            if (this.state == AbstractConnection.State.STARTMAIL || this.state == AbstractConnection.State.RECIPIENT) {
                                if (line.toUpperCase().startsWith("RCPT TO:")) {
                                    this.state = AbstractConnection.State.RECIPIENT;
                                    try {
                                        InternetAddress internetAddress = new InternetAddress(line.substring("RCPT TO:".length()));
                                        recipients.add(internetAddress.getAddress());
                                    }
                                    catch (AddressException e) {
                                        throw new DavMailException("EXCEPTION_INVALID_RECIPIENT", line);
                                    }
                                    this.sendClient("250 Recipient OK");
                                } else {
                                    this.sendClient("500 Unrecognized command");
                                }
                            } else {
                                this.state = AbstractConnection.State.AUTHENTICATED;
                                this.sendClient("503 Bad sequence of commands");
                            }
                        } else if ("DATA".equalsIgnoreCase(command)) {
                            if (this.state == AbstractConnection.State.RECIPIENT) {
                                this.state = AbstractConnection.State.MAILDATA;
                                this.sendClient("354 Start mail input; end with <CRLF>.<CRLF>");
                                try {
                                    int b;
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    DoubleDotInputStream doubleDotInputStream = new DoubleDotInputStream(this.in);
                                    while ((b = doubleDotInputStream.read()) >= 0) {
                                        baos.write(b);
                                    }
                                    MimeMessage mimeMessage = new MimeMessage(null, (InputStream)new SharedByteArrayInputStream(baos.toByteArray()));
                                    this.session.sendMessage(recipients, mimeMessage);
                                    this.state = AbstractConnection.State.AUTHENTICATED;
                                    this.sendClient("250 Queued mail for delivery");
                                }
                                catch (Exception e) {
                                    DavGatewayTray.error(e);
                                    this.state = AbstractConnection.State.AUTHENTICATED;
                                    String error = e.getMessage();
                                    if (error == null) {
                                        error = e.toString();
                                    }
                                    this.sendClient("451 Error : " + error.replaceAll("[\\r\\n]", ""));
                                }
                            } else {
                                this.state = AbstractConnection.State.AUTHENTICATED;
                                this.sendClient("503 Bad sequence of commands");
                            }
                        } else if ("RSET".equalsIgnoreCase(command)) {
                            recipients.clear();
                            this.state = this.state == AbstractConnection.State.STARTMAIL || this.state == AbstractConnection.State.RECIPIENT || this.state == AbstractConnection.State.MAILDATA || this.state == AbstractConnection.State.AUTHENTICATED ? AbstractConnection.State.AUTHENTICATED : AbstractConnection.State.INITIAL;
                            this.sendClient("250 OK Reset");
                        } else {
                            this.sendClient("500 Unrecognized command");
                        }
                    }
                } else {
                    this.sendClient("500 Unrecognized command");
                }
                this.os.flush();
            }
        }
        catch (SocketException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_CONNECTION_CLOSED", new Object[0]));
        }
        catch (Exception e) {
            DavGatewayTray.log(e);
            try {
                this.sendClient("421 " + (e.getMessage() == null ? e : e.getMessage()) + "\n");
            }
            catch (IOException e2) {
                DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", new Object[0]), e2);
            }
        }
        finally {
            this.close();
        }
        DavGatewayTray.resetIcon();
    }

    protected void authenticate() throws IOException {
        try {
            this.session = ExchangeSessionFactory.getInstance(this.userName, this.password);
            this.logConnection("LOGON", this.userName);
            this.sendClient("235 OK Authenticated");
            this.state = AbstractConnection.State.AUTHENTICATED;
        }
        catch (Exception e) {
            this.logConnection("FAILED", this.userName);
            DavGatewayTray.error(e);
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            message = message.replaceAll("\\n", " ");
            this.sendClient("535 Authentication failed " + message);
            this.state = AbstractConnection.State.INITIAL;
        }
    }

    protected void decodeCredentials(String encodedCredentials) throws IOException {
        int endIndex;
        String decodedCredentials = IOUtil.decodeBase64AsString(encodedCredentials);
        int startIndex = decodedCredentials.indexOf(0);
        if (startIndex >= 0) {
            endIndex = decodedCredentials.indexOf(0, startIndex + 1);
            if (endIndex < 0) {
                throw new DavMailException("EXCEPTION_INVALID_CREDENTIALS", new Object[0]);
            }
        } else {
            throw new DavMailException("EXCEPTION_INVALID_CREDENTIALS", new Object[0]);
        }
        this.userName = decodedCredentials.substring(startIndex + 1, endIndex);
        this.password = decodedCredentials.substring(endIndex + 1);
    }
}

