/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import opennlp.tools.ml.maxent.io.GISModelWriter;
import opennlp.tools.ml.model.AbstractModel;

public class BinaryGISModelWriter
extends GISModelWriter {
    DataOutputStream output;

    public BinaryGISModelWriter(AbstractModel model, File f) throws IOException {
        super(model);
        this.output = f.getName().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream(new FileOutputStream(f))) : new DataOutputStream(new FileOutputStream(f));
    }

    public BinaryGISModelWriter(AbstractModel model, DataOutputStream dos) {
        super(model);
        this.output = dos;
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.output.writeUTF(s);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.output.writeInt(i);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.output.writeDouble(d);
    }

    @Override
    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

