/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyFloatDerived;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyFloat
extends PyObject {
    public static final String exposed_name = "float";
    private static final PyType FLOATTYPE = PyType.fromClass(PyFloat.class);
    private double value;

    public static void typeSetup(PyObject pyObject, PyType.Newstyle newstyle) {
        class Exposed___abs__
        extends PyBuiltinMethodNarrow {
            Exposed___abs__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___abs__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___abs__();
            }
        }
        pyObject.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyFloat.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinMethodNarrow {
            Exposed___float__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___float__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___float__();
            }
        }
        pyObject.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyFloat.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___int__
        extends PyBuiltinMethodNarrow {
            Exposed___int__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___int__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___int__();
            }
        }
        pyObject.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyFloat.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___long__
        extends PyBuiltinMethodNarrow {
            Exposed___long__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___long__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___long__();
            }
        }
        pyObject.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyFloat.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinMethodNarrow {
            Exposed___neg__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___neg__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___neg__();
            }
        }
        pyObject.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyFloat.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___pos__
        extends PyBuiltinMethodNarrow {
            Exposed___pos__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___pos__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___pos__();
            }
        }
        pyObject.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyFloat.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinMethodNarrow {
            Exposed___add__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___add__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___add__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyFloat.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___div__
        extends PyBuiltinMethodNarrow {
            Exposed___div__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___div__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___div__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyFloat.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinMethodNarrow {
            Exposed___divmod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___divmod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___divmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyFloat.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___floordiv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___floordiv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___floordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyFloat.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___mod__
        extends PyBuiltinMethodNarrow {
            Exposed___mod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___mod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___mod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyFloat.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinMethodNarrow {
            Exposed___mul__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___mul__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___mul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyFloat.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___radd__
        extends PyBuiltinMethodNarrow {
            Exposed___radd__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___radd__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___radd__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyFloat.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rdiv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rdiv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rdiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyFloat.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rfloordiv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rfloordiv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rfloordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyFloat.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rmod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rmod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyFloat.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinMethodNarrow {
            Exposed___rmul__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rmul__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rmul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyFloat.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinMethodNarrow {
            Exposed___rsub__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rsub__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rsub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyFloat.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinMethodNarrow {
            Exposed___rtruediv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rtruediv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rtruediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyFloat.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinMethodNarrow {
            Exposed___sub__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___sub__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___sub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyFloat.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinMethodNarrow {
            Exposed___truediv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___truediv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___truediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyFloat.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___rdivmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rdivmod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rdivmod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rdivmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rdivmod__", (PyObject)new PyMethodDescr("__rdivmod__", PyFloat.class, 1, 1, new Exposed___rdivmod__(null, null)));
        class Exposed___rpow__
        extends PyBuiltinMethodNarrow {
            Exposed___rpow__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rpow__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___rpow__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rpow__", (PyObject)new PyMethodDescr("__rpow__", PyFloat.class, 1, 1, new Exposed___rpow__(null, null)));
        class Exposed___cmp__
        extends PyBuiltinMethodNarrow {
            Exposed___cmp__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___cmp__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                int n = ((PyFloat)this.self).float___cmp__(pyObject);
                if (n == -2) {
                    throw Py.TypeError("float.__cmp__(x,y) requires y to be 'float', not a '" + pyObject.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }
        }
        pyObject.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyFloat.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___pow__
        extends PyBuiltinMethodNarrow {
            Exposed___pow__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___pow__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                PyObject pyObject3 = ((PyFloat)this.self).float___pow__(pyObject, pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyFloat)this.self).float___pow__(pyObject, null);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyFloat.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___nonzero__(pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyFloat)this.self).float___nonzero__());
            }
        }
        pyObject.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyFloat.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___repr__
        extends PyBuiltinMethodNarrow {
            Exposed___repr__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___repr__(pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyFloat)this.self).float_toString());
            }
        }
        pyObject.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyFloat.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinMethodNarrow {
            Exposed___str__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___str__(pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyFloat)this.self).float_toString());
            }
        }
        pyObject.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyFloat.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinMethodNarrow {
            Exposed___hash__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___hash__(pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(((PyFloat)this.self).float_hashCode());
            }
        }
        pyObject.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyFloat.class, 0, 0, new Exposed___hash__(null, null)));
        pyObject.__setitem__("__new__", (PyObject)new PyNewWrapper(PyFloat.class, "__new__", -1, -1){

            public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
                return PyFloat.float_new(this, bl, pyType, pyObjectArray, stringArray);
            }
        });
    }

    public static PyObject float_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser(exposed_name, pyObjectArray, stringArray, new String[]{"x"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        if (pyNewWrapper.for_type == pyType) {
            if (pyObject == null) {
                return new PyFloat(0.0);
            }
            return pyObject.__float__();
        }
        if (pyObject == null) {
            return new PyFloatDerived(pyType, 0.0);
        }
        return new PyFloatDerived(pyType, pyObject.__float__().getValue());
    }

    public PyFloat(PyType pyType, double d) {
        super(pyType);
        this.value = d;
    }

    public PyFloat(double d) {
        this(FLOATTYPE, d);
    }

    public PyFloat(float f) {
        this((double)f);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'float' object";
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.float_toString();
    }

    final String float_toString() {
        String string2 = Double.toString(this.value);
        if (string2.indexOf(69) == -1) {
            int n;
            while ((n = string2.length()) > 2 && string2.charAt(n - 1) == '0' && string2.charAt(n - 2) != '.') {
                string2 = string2.substring(0, n - 1);
            }
        }
        return string2;
    }

    public int hashCode() {
        return this.float_hashCode();
    }

    final int float_hashCode() {
        double d = Math.floor(this.value);
        double d2 = this.value - d;
        if (d2 == 0.0) {
            if (d <= 2.147483647E9 && d >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.float___nonzero__();
    }

    final boolean float___nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Double.TYPE || clazz == Number.class || clazz == Double.class || clazz == Object.class || clazz == Serializable.class) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.value);
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.float___cmp__(pyObject);
    }

    final int float___cmp__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return -2;
        }
        double d = PyFloat.coerce(pyObject);
        return this.value < d ? -1 : (this.value > d ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)pyObject).getValue());
        }
        if (pyObject instanceof PyLong) {
            return new PyFloat(((PyLong)pyObject).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyFloat || pyObject instanceof PyInteger || pyObject instanceof PyLong;
    }

    private static final double coerce(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return ((PyFloat)pyObject).value;
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.float___add__(pyObject);
    }

    final PyObject float___add__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value + d);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.float___radd__(pyObject);
    }

    final PyObject float___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.float___sub__(pyObject);
    }

    final PyObject float___sub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value - d);
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.float___rsub__(pyObject);
    }

    final PyObject float___rsub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(d - this.value);
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.float___mul__(pyObject);
    }

    final PyObject float___mul__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value * d);
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.float___rmul__(pyObject);
    }

    final PyObject float___rmul__(PyObject pyObject) {
        return this.__mul__(pyObject);
    }

    public PyObject __div__(PyObject pyObject) {
        return this.float___div__(pyObject);
    }

    final PyObject float___div__(PyObject pyObject) {
        double d;
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        if ((d = PyFloat.coerce(pyObject)) == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.float___rdiv__(pyObject);
    }

    final PyObject float___rdiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(d / this.value);
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.float___floordiv__(pyObject);
    }

    final PyObject float___floordiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(this.value / d));
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.float___rfloordiv__(pyObject);
    }

    final PyObject float___rfloordiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(d / this.value));
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.float___truediv__(pyObject);
    }

    final PyObject float___truediv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.float___rtruediv__(pyObject);
    }

    final PyObject float___rtruediv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(d / this.value);
    }

    private static double modulo(double d, double d2) {
        if (d2 == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double d3 = Math.IEEEremainder(d, d2);
        if (d3 * d2 < 0.0) {
            d3 += d2;
        }
        return d3;
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.float___mod__(pyObject);
    }

    final PyObject float___mod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(this.value, d));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.float___rmod__(pyObject);
    }

    final PyObject float___rmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(d, this.value));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.float___divmod__(pyObject);
    }

    final PyObject float___divmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(this.value / d);
        return new PyTuple(new PyObject[]{new PyFloat(d2), new PyFloat(this.value - d2 * d)});
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(d / this.value);
        return new PyTuple(new PyObject[]{new PyFloat(d2), new PyFloat(d - d2 * this.value)});
    }

    final PyObject float___rdivmod__(PyObject pyObject) {
        return this.__rdivmod__(pyObject);
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.float___pow__(pyObject, pyObject2);
    }

    final PyObject float___pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null) {
            throw Py.TypeError("pow() 3rd argument not allowed unless all arguments are integers");
        }
        return PyFloat._pow(this.value, PyFloat.coerce(pyObject), pyObject2);
    }

    final PyObject float___rpow__(PyObject pyObject) {
        return this.__rpow__(pyObject);
    }

    public PyObject __rpow__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(pyObject), this.value, null);
    }

    private static PyFloat _pow(double d, double d2, PyObject pyObject) {
        if (d2 == 0.0) {
            if (pyObject != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(pyObject)));
            }
            return new PyFloat(1.0);
        }
        if (d == 0.0) {
            if (d2 < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        if (d < 0.0 && d2 != Math.floor(d2)) {
            throw Py.ValueError("negative number cannot be raised to a fractional power");
        }
        double d3 = Math.pow(d, d2);
        if (pyObject == null) {
            return new PyFloat(d3);
        }
        return new PyFloat(PyFloat.modulo(d3, PyFloat.coerce(pyObject)));
    }

    public PyObject __neg__() {
        return this.float___neg__();
    }

    final PyObject float___neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this.float___pos__();
    }

    final PyObject float___pos__() {
        return Py.newFloat(this.value);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.float___abs__();
    }

    final PyObject float___abs__() {
        if (this.value >= 0.0) {
            return Py.newFloat(this.value);
        }
        return this.__neg__();
    }

    public PyObject __int__() {
        return this.float___int__();
    }

    final PyInteger float___int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        throw Py.OverflowError("float too large to convert");
    }

    public PyLong __long__() {
        return this.float___long__();
    }

    final PyLong float___long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this.float___float__();
    }

    final PyFloat float___float__() {
        return Py.newFloat(this.value);
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    public boolean isSequenceType() throws PyIgnoreMethodTag {
        return false;
    }
}

