/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.Util;
import com.pomodorotechnique.server.api.LoginException;
import com.pomodorotechnique.server.api.OfflineServerImpl;
import com.pomodorotechnique.server.api.RestfulServerImpl;
import com.pomodorotechnique.server.api.Server;
import java.awt.Frame;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;

public class LoginWindow
extends JDialog {
    private Server server = null;
    private final Preferences prefs = Preferences.userRoot().node("pomodoroServer");
    private boolean success = false;
    private JButton exitButton;
    private JButton loginButton;
    private JRadioButton loginRadio;
    private JLabel logoLabel;
    private ButtonGroup modeButtonGroup;
    private JRadioButton offlineRadio;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField serverAddressField;
    private JLabel serverAddressLabel;
    private JCheckBox storePasswordCheckBox;
    private JTextField userNameField;
    private JLabel userNameLabel;
    private BindingGroup bindingGroup;

    public boolean isSuccess() {
        return this.success;
    }

    public LoginWindow(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.loadPreferences();
        this.getRootPane().setDefaultButton(this.loginButton);
        Util.decorate(this, true);
    }

    public Server getServer() {
        return this.server;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.modeButtonGroup = new ButtonGroup();
        this.userNameLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.serverAddressLabel = new JLabel();
        this.serverAddressField = new JTextField();
        this.userNameField = new JTextField();
        this.passwordField = new JPasswordField();
        this.loginButton = new JButton();
        this.exitButton = new JButton();
        this.offlineRadio = new JRadioButton();
        this.loginRadio = new JRadioButton();
        this.storePasswordCheckBox = new JCheckBox();
        this.logoLabel = new JLabel();
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(LoginWindow.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.userNameLabel.setText(resourceMap.getString("userNameLabel.text", new Object[0]));
        this.userNameLabel.setName("userNameLabel");
        this.passwordLabel.setText(resourceMap.getString("passwordLabel.text", new Object[0]));
        this.passwordLabel.setName("passwordLabel");
        this.serverAddressLabel.setText(resourceMap.getString("serverAddressLabel.text", new Object[0]));
        this.serverAddressLabel.setName("serverAddressLabel");
        this.serverAddressField.setText(resourceMap.getString("serverAddressField.text", new Object[0]));
        this.serverAddressField.setName("serverAddressField");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.loginButton, ELProperty.create("${action}"), this.serverAddressField, BeanProperty.create("action"));
        this.bindingGroup.addBinding(binding);
        this.userNameField.setText(resourceMap.getString("userNameField.text", new Object[0]));
        this.userNameField.setName("userNameField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.loginButton, ELProperty.create("${action}"), this.userNameField, BeanProperty.create("action"));
        this.bindingGroup.addBinding(binding);
        this.passwordField.setText(resourceMap.getString("passwordField.text", new Object[0]));
        this.passwordField.setName("passwordField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.loginButton, ELProperty.create("${action}"), this.passwordField, BeanProperty.create("action"));
        this.bindingGroup.addBinding(binding);
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(LoginWindow.class, this);
        this.loginButton.setAction(actionMap.get("login"));
        this.loginButton.setText(resourceMap.getString("loginButton.text", new Object[0]));
        this.loginButton.setName("loginButton");
        this.exitButton.setAction(actionMap.get("quit"));
        this.exitButton.setText(resourceMap.getString("exitButton.text", new Object[0]));
        this.exitButton.setName("exitButton");
        this.offlineRadio.setAction(actionMap.get("modeChanged"));
        this.modeButtonGroup.add(this.offlineRadio);
        this.offlineRadio.setText(resourceMap.getString("offlineRadio.text", new Object[0]));
        this.offlineRadio.setName("offlineRadio");
        this.loginRadio.setAction(actionMap.get("modeChanged"));
        this.modeButtonGroup.add(this.loginRadio);
        this.loginRadio.setText(resourceMap.getString("loginRadio.text", new Object[0]));
        this.loginRadio.setName("loginRadio");
        this.storePasswordCheckBox.setText(resourceMap.getString("storePasswordCheckBox.text", new Object[0]));
        this.storePasswordCheckBox.setName("storePasswordCheckBox");
        this.logoLabel.setIcon(resourceMap.getIcon("logoLabel.icon"));
        this.logoLabel.setText(resourceMap.getString("logoLabel.text", new Object[0]));
        this.logoLabel.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("logoLabel.border.lineColor")));
        this.logoLabel.setName("logoLabel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.loginButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton).addContainerGap(179, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.offlineRadio).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userNameLabel, -2, 93, -2).addComponent(this.passwordLabel).addComponent(this.serverAddressLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.passwordField).addComponent(this.userNameField).addComponent(this.storePasswordCheckBox).addComponent(this.serverAddressField, -2, 173, -2))).addComponent(this.loginRadio)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.logoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.logoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.offlineRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loginRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverAddressField, -2, -1, -2).addComponent(this.serverAddressLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameField, -2, -1, -2).addComponent(this.userNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordField, -2, -1, -2).addComponent(this.passwordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.storePasswordCheckBox).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loginButton).addComponent(this.exitButton)).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void storePreferences() {
        this.prefs.put("mode", this.offlineRadio.isSelected() ? "O" : "S");
        this.prefs.put("username", this.userNameField.getText());
        this.prefs.put("serverAddress", this.serverAddressField.getText());
        boolean storePassword = this.storePasswordCheckBox.isSelected();
        this.prefs.put("storePassword", storePassword ? "Y" : "N");
        if (storePassword) {
            this.prefs.put("password", new String(this.passwordField.getPassword()));
        } else {
            this.prefs.put("password", "");
        }
    }

    private void loadPreferences() {
        boolean offlineMode = this.prefs.get("mode", "O").equals("O");
        this.modeButtonGroup.setSelected(this.offlineRadio.getModel(), offlineMode);
        this.modeButtonGroup.setSelected(this.loginRadio.getModel(), !offlineMode);
        this.serverAddressField.setText(this.prefs.get("serverAddress", ""));
        this.userNameField.setText(this.prefs.get("username", ""));
        this.passwordField.setText(this.prefs.get("password", ""));
        this.storePasswordCheckBox.setSelected(this.prefs.get("storePassword", "N").equals("Y"));
        this.enableControls();
        this.loginButton.requestFocus();
    }

    private void enableControls() {
        boolean onlineMode = this.loginRadio.isSelected();
        this.serverAddressField.setEnabled(onlineMode);
        this.userNameField.setEnabled(onlineMode);
        this.passwordField.setEnabled(onlineMode);
        this.storePasswordCheckBox.setEnabled(onlineMode);
    }

    @Action
    public void login() {
        try {
            this.server = this.offlineRadio.isSelected() ? new OfflineServerImpl() : new RestfulServerImpl(this.userNameField.getText(), new String(this.passwordField.getPassword()));
            this.storePreferences();
            this.success = true;
            this.setVisible(false);
        }
        catch (LoginException t) {
            JOptionPane.showMessageDialog(this, "You specified invalid credentials", "Unable to log in", 2);
            t.printStackTrace();
        }
        catch (IOException t) {
            JOptionPane.showMessageDialog(this, "Communication error occured. Please try again later.", "Unable to log in", 0);
            t.printStackTrace();
        }
    }

    @Action
    public void modeChanged() {
        this.enableControls();
    }
}

