/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui.workitem;

import com.pomodorotechnique.client.ui.workitem.PomodoroIcon;
import com.pomodorotechnique.client.ui.workitem.WorkItemRenderer;
import com.pomodorotechnique.server.InterruptionType;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.StatusType;
import com.pomodorotechnique.server.WorkitemType;

public class PomodoroRenderer
extends WorkItemRenderer {
    public void setValue(WorkitemType w) {
        StringBuilder r = new StringBuilder();
        for (PomodoroType p : w.getPomodoro()) {
            if (p.getStatus().equals((Object)StatusType.NEW) && p.isPlanned()) {
                r.append('N');
            } else if (p.getStatus().equals((Object)StatusType.COMPLETED) && p.isPlanned()) {
                r.append('C');
            } else if (p.getStatus().equals((Object)StatusType.FAILED) && p.isPlanned()) {
                r.append('F');
            } else if (p.getStatus().equals((Object)StatusType.NEW) && !p.isPlanned()) {
                r.append('n');
            } else if (p.getStatus().equals((Object)StatusType.COMPLETED) && !p.isPlanned()) {
                r.append('c');
            } else if (p.getStatus().equals((Object)StatusType.FAILED) && !p.isPlanned()) {
                r.append('f');
            } else if (p.getStatus().equals((Object)StatusType.STARTED)) {
                if (p.isPlanned()) {
                    r.append('S');
                } else {
                    r.append('s');
                }
            } else {
                r.append('?');
            }
            for (InterruptionType i : p.getInterruption()) {
                r.append('\'');
            }
        }
        this.setIcon(new PomodoroIcon(w));
    }
}

