/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.controlsfx.control.RangeSlider;
import org.controlsfx.tools.Utils;

public class RangeSliderBehavior
extends BehaviorBase<RangeSlider> {
    private static final List<KeyBinding> RANGESLIDER_BINDINGS = new ArrayList<KeyBinding>();
    private Callback<Void, FocusedChild> selectedValue;

    public RangeSliderBehavior(RangeSlider slider) {
        super((Control)slider, RANGESLIDER_BINDINGS);
    }

    protected void callAction(String s) {
        if ("Home".equals(s) || "Home2".equals(s)) {
            this.home();
        } else if ("End".equals(s) || "End2".equals(s)) {
            this.end();
        } else if ("IncrementValue".equals(s) || "IncrementValue2".equals(s)) {
            this.incrementValue();
        } else if ("DecrementValue".equals(s) || "DecrementValue2".equals(s)) {
            this.decrementValue();
        } else {
            super.callAction(s);
        }
    }

    public void setSelectedValue(Callback<Void, FocusedChild> c) {
        this.selectedValue = c;
    }

    public void trackPress(MouseEvent e, double position) {
        RangeSlider rangeSlider = (RangeSlider)this.getControl();
        if (!rangeSlider.isFocused()) {
            rangeSlider.requestFocus();
        }
        if (this.selectedValue != null) {
            double newPosition = rangeSlider.getOrientation().equals((Object)Orientation.HORIZONTAL) ? position * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin() : (1.0 - position) * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin();
            if (newPosition < rangeSlider.getLowValue()) {
                rangeSlider.adjustLowValue(newPosition);
            } else {
                rangeSlider.adjustHighValue(newPosition);
            }
        }
    }

    public void trackRelease(MouseEvent e, double position) {
    }

    public void lowThumbPressed(MouseEvent e, double position) {
        RangeSlider rangeSlider = (RangeSlider)this.getControl();
        if (!rangeSlider.isFocused()) {
            rangeSlider.requestFocus();
        }
        rangeSlider.setLowValueChanging(true);
    }

    public void lowThumbDragged(MouseEvent e, double position) {
        RangeSlider rangeSlider = (RangeSlider)this.getControl();
        double newValue = Utils.clamp(rangeSlider.getMin(), position * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin(), rangeSlider.getMax());
        rangeSlider.setLowValue(newValue);
    }

    public void lowThumbReleased(MouseEvent e) {
        RangeSlider rangeSlider = (RangeSlider)this.getControl();
        rangeSlider.setLowValueChanging(false);
        if (rangeSlider.isSnapToTicks()) {
            rangeSlider.setLowValue(this.snapValueToTicks(rangeSlider.getLowValue()));
        }
    }

    void home() {
        RangeSlider slider = (RangeSlider)this.getControl();
        slider.adjustHighValue(slider.getMin());
    }

    void decrementValue() {
        RangeSlider slider = (RangeSlider)this.getControl();
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (slider.isSnapToTicks()) {
                    slider.adjustHighValue(slider.getHighValue() - this.computeIncrement());
                } else {
                    slider.decrementHighValue();
                }
            } else if (slider.isSnapToTicks()) {
                slider.adjustLowValue(slider.getLowValue() - this.computeIncrement());
            } else {
                slider.decrementLowValue();
            }
        }
    }

    void end() {
        RangeSlider slider = (RangeSlider)this.getControl();
        slider.adjustHighValue(slider.getMax());
    }

    void incrementValue() {
        RangeSlider slider = (RangeSlider)this.getControl();
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (slider.isSnapToTicks()) {
                    slider.adjustHighValue(slider.getHighValue() + this.computeIncrement());
                } else {
                    slider.incrementHighValue();
                }
            } else if (slider.isSnapToTicks()) {
                slider.adjustLowValue(slider.getLowValue() + this.computeIncrement());
            } else {
                slider.incrementLowValue();
            }
        }
    }

    double computeIncrement() {
        RangeSlider rangeSlider = (RangeSlider)this.getControl();
        double d = 0.0;
        d = rangeSlider.getMinorTickCount() != 0 ? rangeSlider.getMajorTickUnit() / (double)(Math.max(rangeSlider.getMinorTickCount(), 0) + 1) : rangeSlider.getMajorTickUnit();
        if (rangeSlider.getBlockIncrement() > 0.0 && rangeSlider.getBlockIncrement() < d) {
            return d;
        }
        return rangeSlider.getBlockIncrement();
    }

    private double snapValueToTicks(double d) {
        RangeSlider rangeSlider = (RangeSlider)this.getControl();
        double d1 = d;
        double d2 = 0.0;
        d2 = rangeSlider.getMinorTickCount() != 0 ? rangeSlider.getMajorTickUnit() / (double)(Math.max(rangeSlider.getMinorTickCount(), 0) + 1) : rangeSlider.getMajorTickUnit();
        int i = (int)((d1 - rangeSlider.getMin()) / d2);
        double d3 = (double)i * d2 + rangeSlider.getMin();
        double d4 = (double)(i + 1) * d2 + rangeSlider.getMin();
        d1 = Utils.nearest(d3, d1, d4);
        return Utils.clamp(rangeSlider.getMin(), d1, rangeSlider.getMax());
    }

    public void highThumbReleased(MouseEvent e) {
        RangeSlider slider = (RangeSlider)this.getControl();
        slider.setHighValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setHighValue(this.snapValueToTicks(slider.getHighValue()));
        }
    }

    public void highThumbPressed(MouseEvent e, double position) {
        RangeSlider slider = (RangeSlider)this.getControl();
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.setHighValueChanging(true);
    }

    public void highThumbDragged(MouseEvent e, double position) {
        RangeSlider slider = (RangeSlider)this.getControl();
        slider.setHighValue(Utils.clamp(slider.getMin(), position * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMax()));
    }

    public void moveRange(double position) {
        RangeSlider slider = (RangeSlider)this.getControl();
        double min = slider.getMin();
        double max = slider.getMax();
        double lowValue = slider.getLowValue();
        double newLowValue = Utils.clamp(min, lowValue + position * (max - min) / (slider.getOrientation() == Orientation.HORIZONTAL ? slider.getWidth() : slider.getHeight()), max);
        double highValue = slider.getHighValue();
        double newHighValue = Utils.clamp(min, highValue + position * (max - min) / (slider.getOrientation() == Orientation.HORIZONTAL ? slider.getWidth() : slider.getHeight()), max);
        if (newLowValue <= min || newHighValue >= max) {
            return;
        }
        slider.setLowValueChanging(true);
        slider.setHighValueChanging(true);
        slider.setLowValue(newLowValue);
        slider.setHighValue(newHighValue);
    }

    public void confirmRange() {
        RangeSlider slider = (RangeSlider)this.getControl();
        slider.setLowValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setLowValue(this.snapValueToTicks(slider.getLowValue()));
        }
        slider.setHighValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setHighValue(this.snapValueToTicks(slider.getHighValue()));
        }
    }

    static {
        RANGESLIDER_BINDINGS.add(new KeyBinding(KeyCode.F4, "TraverseDebug").alt().ctrl().shift());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.LEFT, "DecrementValue"));
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_LEFT, "DecrementValue"));
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.UP, "IncrementValue").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_UP, "IncrementValue").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.RIGHT, "IncrementValue"));
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_RIGHT, "IncrementValue"));
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.DOWN, "DecrementValue").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_DOWN, "DecrementValue").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.LEFT, "TraverseLeft").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_LEFT, "TraverseLeft").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.UP, "TraverseUp"));
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_UP, "TraverseUp"));
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.RIGHT, "TraverseRight").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_RIGHT, "TraverseRight").vertical());
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.DOWN, "TraverseDown"));
        RANGESLIDER_BINDINGS.add((KeyBinding)new RangeSliderKeyBinding(KeyCode.KP_DOWN, "TraverseDown"));
        RANGESLIDER_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_RELEASED, "Home"));
        RANGESLIDER_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_RELEASED, "End"));
    }

    public static enum FocusedChild {
        LOW_THUMB,
        HIGH_THUMB,
        RANGE_BAR,
        NONE;

    }

    public static class RangeSliderKeyBinding
    extends OrientedKeyBinding {
        public RangeSliderKeyBinding(KeyCode code, String action) {
            super(code, action);
        }

        public RangeSliderKeyBinding(KeyCode code, EventType<KeyEvent> type, String action) {
            super(code, type, action);
        }

        public boolean getVertical(Control control) {
            return ((RangeSlider)control).getOrientation() == Orientation.VERTICAL;
        }
    }
}

