/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AboutAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.ArrangeAction;
import org.jhotdraw.app.action.ClearRecentFilesAction;
import org.jhotdraw.app.action.CloseAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExitAction;
import org.jhotdraw.app.action.FocusAction;
import org.jhotdraw.app.action.NewAction;
import org.jhotdraw.app.action.OpenAction;
import org.jhotdraw.app.action.OpenRecentAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.PrintAction;
import org.jhotdraw.app.action.RedoAction;
import org.jhotdraw.app.action.SaveAction;
import org.jhotdraw.app.action.SaveAsAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.ToggleToolBarAction;
import org.jhotdraw.app.action.UndoAction;
import org.jhotdraw.gui.Arrangeable;
import org.jhotdraw.gui.MDIDesktopPane;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class DefaultMDIApplication
extends AbstractApplication {
    private JFrame parentFrame;
    private JScrollPane scrollPane;
    private MDIDesktopPane desktopPane;
    private Preferences prefs;
    private LinkedList<Action> toolBarActions;

    protected void initApplicationActions() {
        ApplicationModel mo = this.getModel();
        mo.putAction("application.about", new AboutAction(this));
        mo.putAction("application.exit", new ExitAction(this));
        mo.putAction("file.new", new NewAction(this));
        mo.putAction("file.open", new OpenAction(this));
        mo.putAction("file.clearRecentFiles", new ClearRecentFilesAction(this));
        mo.putAction("file.save", new SaveAction(this));
        mo.putAction("file.saveAs", new SaveAsAction(this));
        mo.putAction("file.close", new CloseAction(this));
        mo.putAction("file.print", new PrintAction(this));
        mo.putAction("edit.undo", new UndoAction(this));
        mo.putAction("edit.redo", new RedoAction(this));
        mo.putAction("edit.cut", new CutAction());
        mo.putAction("edit.copy", new CopyAction());
        mo.putAction("edit.paste", new PasteAction());
        mo.putAction("edit.delete", new DeleteAction());
        mo.putAction("edit.duplicate", new DuplicateAction());
        mo.putAction("edit.selectAll", new SelectAllAction());
        mo.putAction("window.arrangeVertical", new ArrangeAction(this.desktopPane, Arrangeable.Arrangement.VERTICAL));
        mo.putAction("window.arrangeHorizontal", new ArrangeAction(this.desktopPane, Arrangeable.Arrangement.HORIZONTAL));
        mo.putAction("window.arrangeCascade", new ArrangeAction(this.desktopPane, Arrangeable.Arrangement.CASCADE));
    }

    @Override
    protected void initViewActions(View p) {
        p.putAction("window.focus", new FocusAction(p));
    }

    @Override
    public void launch(String[] args) {
        super.launch(args);
    }

    @Override
    public void init() {
        this.initLookAndFeel();
        super.init();
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLabels();
        this.parentFrame = new JFrame(this.getName());
        this.parentFrame.setDefaultCloseOperation(0);
        this.desktopPane = new MDIDesktopPane();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.desktopPane);
        this.toolBarActions = new LinkedList();
        this.initApplicationActions();
        this.parentFrame.getContentPane().add(this.wrapDesktopPane(this.scrollPane, this.toolBarActions));
        this.parentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DefaultMDIApplication.this.getModel().getAction("application.exit").actionPerformed(new ActionEvent(DefaultMDIApplication.this.parentFrame, 1001, "windowClosing"));
            }
        });
        this.parentFrame.setJMenuBar(this.createMenuBar());
        PreferencesUtil.installFramePrefsHandler(this.prefs, "parentFrame", this.parentFrame);
        this.parentFrame.setVisible(true);
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        System.setProperty("swing.aatext", "true");
    }

    protected void initLookAndFeel() {
        try {
            String lafName;
            if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                lafName = UIManager.getCrossPlatformLookAndFeelClassName();
            } else {
                lafName = UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "");
        }
    }

    @Override
    public void show(final View p) {
        if (!p.isShowing()) {
            boolean moved;
            p.setShowing(true);
            final JInternalFrame f = new JInternalFrame();
            f.setDefaultCloseOperation(0);
            f.setClosable(true);
            f.setMaximizable(true);
            f.setResizable(true);
            f.setIconifiable(false);
            this.updateViewTitle(p, f);
            PreferencesUtil.installInternalFramePrefsHandler(this.prefs, "view", f, this.desktopPane);
            Point loc = f.getLocation();
            block2: do {
                moved = false;
                for (View aView : this.views()) {
                    if (aView == p || !aView.isShowing() || !SwingUtilities.getRootPane(aView.getComponent()).getParent().getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block2;
                }
            } while (moved);
            f.setLocation(loc);
            f.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent evt) {
                    DefaultMDIApplication.this.getModel().getAction("file.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent evt) {
                    if (p == DefaultMDIApplication.this.getActiveView()) {
                        DefaultMDIApplication.this.setActiveView(null);
                    }
                    p.stop();
                }
            });
            p.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name == "hasUnsavedChanges" || name == "file") {
                        DefaultMDIApplication.this.updateViewTitle(p, f);
                    }
                }
            });
            f.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("selected") && evt.getNewValue().equals(Boolean.TRUE)) {
                        DefaultMDIApplication.this.setActiveView(p);
                    }
                }
            });
            f.getContentPane().add(p.getComponent());
            f.setVisible(true);
            this.desktopPane.add(f);
            f.toFront();
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            p.getComponent().requestFocusInWindow();
            p.start();
        }
    }

    @Override
    public void hide(View p) {
        if (p.isShowing()) {
            JInternalFrame f = (JInternalFrame)SwingUtilities.getRootPane(p.getComponent()).getParent();
            f.setVisible(false);
            f.remove(p.getComponent());
            this.desktopPane.remove(f);
            f.dispose();
        }
    }

    @Override
    public boolean isSharingToolsAmongViews() {
        return true;
    }

    @Override
    public Component getComponent() {
        return this.parentFrame;
    }

    protected Component wrapDesktopPane(Component c, LinkedList<Action> toolBarActions) {
        if (this.getModel() != null) {
            int id = 0;
            for (JToolBar tb : new ReversedList<JToolBar>(this.getModel().createToolBars(this, null))) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)tb, "North");
                panel.add(c, "Center");
                c = panel;
                PreferencesUtil.installToolBarPrefsHandler(this.prefs, "toolbar." + ++id, tb);
                toolBarActions.addFirst(new ToggleToolBarAction(tb, tb.getName()));
            }
        }
        return c;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        for (JMenu mm : this.getModel().createMenus(this, null)) {
            mb.add(mm);
        }
        mb.add(this.createWindowMenu());
        mb.add(this.createHelpMenu());
        return mb;
    }

    protected JMenu createFileMenu() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        ApplicationModel model = this.getModel();
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu();
        labels.configureMenu(m, "file");
        m.add(model.getAction("file.new"));
        m.add(model.getAction("file.open"));
        if (model.getAction("file.openDirectory") != null) {
            JMenuItem mi = m.add(model.getAction("file.openDirectory"));
            mi.setIcon(null);
        }
        final JMenu openRecentMenu = new JMenu();
        labels.configureMenu(openRecentMenu, "file.openRecent");
        openRecentMenu.add(model.getAction("file.clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        m.add(model.getAction("file.close"));
        m.add(model.getAction("file.save"));
        m.add(model.getAction("file.saveAs"));
        if (model.getAction("file.export") != null) {
            JMenuItem jMenuItem = m.add(model.getAction("file.export"));
        }
        if (model.getAction("file.print") != null) {
            m.addSeparator();
            m.add(model.getAction("file.print"));
        }
        m.addSeparator();
        m.add(model.getAction("application.exit"));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                ApplicationModel mo = DefaultMDIApplication.this.getModel();
                if (name == "recentFiles") {
                    DefaultMDIApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    protected void updateViewTitle(View v, JInternalFrame f) {
        File file = v.getFile();
        String title = file == null ? this.labels.getString("unnamedFile") : file.getName();
        if (v.hasUnsavedChanges()) {
            title = title + "*";
        }
        v.setTitle(this.labels.getFormatted("internalFrame.title", title, this.getName(), v.getMultipleOpenId()));
        f.setTitle(v.getTitle());
    }

    protected void updateOpenRecentMenu(JMenu openRecentMenu) {
        if (openRecentMenu.getItemCount() > 0) {
            JMenuItem clearRecentFilesItem = openRecentMenu.getItem(openRecentMenu.getItemCount() - 1);
            openRecentMenu.removeAll();
            for (File f : this.recentFiles()) {
                openRecentMenu.add(new OpenRecentAction(this, f));
            }
            if (this.recentFiles().size() > 0) {
                openRecentMenu.addSeparator();
            }
            openRecentMenu.add(clearRecentFilesItem);
        }
    }

    protected JMenu createWindowMenu() {
        JMenu m;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        ApplicationModel mo = this.getModel();
        final JMenu windowMenu = m = new JMenu();
        labels.configureMenu(m, "window");
        m.add(mo.getAction("window.arrangeCascade"));
        m.add(mo.getAction("window.arrangeVertical"));
        m.add(mo.getAction("window.arrangeHorizontal"));
        m.addSeparator();
        for (View pr : this.views()) {
            if (pr.getAction("window.focus") == null) continue;
            windowMenu.add(pr.getAction("window.focus"));
        }
        if (this.toolBarActions.size() > 0) {
            m.addSeparator();
            for (Action a : this.toolBarActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                m.add(cbmi);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                ApplicationModel mo = DefaultMDIApplication.this.getModel();
                if (name == "viewCount") {
                    JMenu m = windowMenu;
                    m.removeAll();
                    m.add(mo.getAction("window.arrangeCascade"));
                    m.add(mo.getAction("window.arrangeVertical"));
                    m.add(mo.getAction("window.arrangeHorizontal"));
                    m.addSeparator();
                    for (View pr : DefaultMDIApplication.this.views()) {
                        if (pr.getAction("window.focus") == null) continue;
                        m.add(pr.getAction("window.focus"));
                    }
                    if (DefaultMDIApplication.this.toolBarActions.size() > 0) {
                        m.addSeparator();
                        for (Action a : DefaultMDIApplication.this.toolBarActions) {
                            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                            Actions.configureJCheckBoxMenuItem(cbmi, a);
                            m.add(cbmi);
                        }
                    }
                }
            }
        });
        return m;
    }

    protected JMenu createHelpMenu() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        ApplicationModel mo = this.getModel();
        JMenu m = new JMenu();
        labels.configureMenu(m, labels.getString("help"));
        m.add(mo.getAction("application.about"));
        return m;
    }
}

