/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractSaveBeforeAction
extends AbstractViewAction {
    private Component oldFocusOwner;

    public AbstractSaveBeforeAction(Application app) {
        super(app);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final View p = this.getActiveView();
        if (p.isEnabled()) {
            final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            Window wAncestor = SwingUtilities.getWindowAncestor(p.getComponent());
            this.oldFocusOwner = wAncestor == null ? null : wAncestor.getFocusOwner();
            p.setEnabled(false);
            if (p.hasUnsavedChanges()) {
                JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + labels.getString("file.saveBefore.doYouWantToSave.message"), 2);
                Object[] options = new Object[]{labels.getString("file.saveBefore.saveOption.text"), labels.getString("file.saveBefore.cancelOption.text"), labels.getString("file.saveBefore.dontSaveOption.text")};
                pane.setOptions(options);
                pane.setInitialValue(options[0]);
                pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
                JSheet.showSheet(pane, p.getComponent(), new SheetListener(){

                    @Override
                    public void optionSelected(SheetEvent evt) {
                        Object value = evt.getValue();
                        if (value == null || value.equals(labels.getString("file.saveBefore.cancelOption.text"))) {
                            p.setEnabled(true);
                        } else if (value.equals(labels.getString("file.saveBefore.dontSaveOption.text"))) {
                            AbstractSaveBeforeAction.this.doIt(p);
                            p.setEnabled(true);
                        } else if (value.equals(labels.getString("file.saveBefore.saveOption.text"))) {
                            AbstractSaveBeforeAction.this.saveChanges(p);
                        }
                    }
                });
            } else {
                this.doIt(p);
                p.setEnabled(true);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            }
        }
    }

    protected void saveChanges(final View p) {
        if (p.getFile() == null) {
            JFileChooser fileChooser = p.getSaveChooser();
            JSheet.showSaveSheet(fileChooser, p.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()) : evt.getFileChooser().getSelectedFile();
                        AbstractSaveBeforeAction.this.saveToFile(p, file);
                    } else {
                        p.setEnabled(true);
                        if (AbstractSaveBeforeAction.this.oldFocusOwner != null) {
                            AbstractSaveBeforeAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        } else {
            this.saveToFile(p, p.getFile());
        }
    }

    protected void saveToFile(final View p, final File file) {
        p.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    p.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                AbstractSaveBeforeAction.this.fileSaved(p, file, value);
            }
        });
    }

    protected void fileSaved(View p, File file, Object value) {
        if (value == null) {
            p.setFile(file);
            p.markChangesAsSaved();
            this.doIt(p);
        } else {
            String message = value instanceof Throwable && ((Throwable)value).getMessage() != null ? ((Throwable)value).getMessage() : value.toString();
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            JSheet.showMessageSheet((Component)this.getActiveView().getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.saveBefore.couldntSave.message", file.getName()) + "</b><br>" + (message == null ? "" : message)), 0);
        }
        p.setEnabled(true);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }

    protected abstract void doIt(View var1);
}

