/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.jhotdraw.app.EditableComponent;
import org.jhotdraw.util.ResourceBundleUtil;

public class DeleteAction
extends TextAction {
    public static final String ID = "edit.delete";

    public DeleteAction() {
        super(ID);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (focusOwner != null && focusOwner instanceof EditableComponent) {
            ((EditableComponent)((Object)focusOwner)).delete();
        } else {
            this.deleteNextChar(evt);
        }
    }

    public void deleteNextChar(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        boolean beep = true;
        if (target != null && target.isEditable()) {
            try {
                Document doc = target.getDocument();
                Caret caret = target.getCaret();
                int dot = caret.getDot();
                int mark = caret.getMark();
                if (dot != mark) {
                    doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                    beep = false;
                } else if (dot < doc.getLength()) {
                    doc.remove(dot, 1);
                    beep = false;
                }
            }
            catch (BadLocationException bl) {
                // empty catch block
            }
        }
        if (beep) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

