/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import org.jhotdraw.color.AbstractColorSystem;

public class HSVRGBColorSystem
extends AbstractColorSystem {
    @Override
    public int toRGB(float ... components) {
        float blue;
        float green;
        float red;
        float hue = components[0] * 360.0f;
        float saturation = components[1];
        float value = components[2];
        int hi = (int)(Math.floor(hue / 60.0f) % 6.0);
        float f = (float)((double)(hue / 60.0f) - Math.floor(hue / 60.0f));
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (hi) {
            case 0: {
                red = value;
                green = t;
                blue = p;
                break;
            }
            case 1: {
                red = q;
                green = value;
                blue = p;
                break;
            }
            case 2: {
                red = p;
                green = value;
                blue = t;
                break;
            }
            case -3: 
            case 3: {
                red = p;
                green = q;
                blue = value;
                break;
            }
            case -2: 
            case 4: {
                red = t;
                green = p;
                blue = value;
                break;
            }
            case -1: 
            case 5: {
                red = value;
                green = p;
                blue = q;
                break;
            }
            default: {
                blue = 0.0f;
                green = 0.0f;
                red = 0.0f;
            }
        }
        int rgb = (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
        return rgb;
    }

    @Override
    public float[] toComponents(int red, int green, int blue, float[] components) {
        float min;
        if (components == null || components.length != 3) {
            components = new float[3];
        }
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float max = Math.max(Math.max(r, g), b);
        float hue = max == (min = Math.min(Math.min(r, g), b)) ? 0.0f : (max == r && g >= b ? 60.0f * (g - b) / (max - min) : (max == r && g < b ? 60.0f * (g - b) / (max - min) + 360.0f : (max == g ? 60.0f * (b - r) / (max - min) + 120.0f : 60.0f * (r - g) / (max - min) + 240.0f)));
        float value = max;
        float saturation = max == 0.0f ? 0.0f : (max - min) / max;
        components[0] = hue / 360.0f;
        components[1] = saturation;
        components[2] = value;
        return components;
    }

    @Override
    public int getComponentCount() {
        return 3;
    }
}

