/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.geom.Geom;

public abstract class AbstractLineDecoration
implements LineDecoration {
    private boolean isFilled;
    private boolean isStroked;
    private boolean isSolid;

    public AbstractLineDecoration(boolean isFilled, boolean isStroked, boolean isSolid) {
        this.isFilled = isFilled;
        this.isStroked = isStroked;
        this.isSolid = isSolid;
    }

    protected boolean isFilled() {
        return this.isFilled;
    }

    protected boolean isStroked() {
        return this.isStroked;
    }

    protected boolean isSolid() {
        return this.isSolid;
    }

    @Override
    public void draw(Graphics2D g, Figure f, Point2D.Double p1, Point2D.Double p2) {
        Color color;
        GeneralPath path = this.getTransformedDecoratorPath(f, p1, p2);
        if (this.isFilled && (color = this.isSolid ? AttributeKeys.STROKE_COLOR.get(f) : AttributeKeys.FILL_COLOR.get(f)) != null) {
            g.setColor(color);
            g.fill(path);
        }
        if (this.isStroked && (color = AttributeKeys.STROKE_COLOR.get(f)) != null) {
            g.setColor(color);
            g.setStroke(AttributeKeys.getStroke(f));
            g.draw(path);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea(Figure f, Point2D.Double p1, Point2D.Double p2) {
        GeneralPath path = this.getTransformedDecoratorPath(f, p1, p2);
        Rectangle2D b = path.getBounds2D();
        Rectangle2D.Double area = new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        if (this.isStroked) {
            double strokeWidth = AttributeKeys.STROKE_WIDTH.get(f);
            int strokeJoin = AttributeKeys.STROKE_JOIN.get(f);
            double miterLimit = AttributeKeys.STROKE_MITER_LIMIT.get(f) * strokeWidth;
            double grow = strokeJoin == 0 ? (double)((int)(1.0 + strokeWidth / 2.0 * miterLimit)) : (double)((int)(1.0 + strokeWidth / 2.0));
            Geom.grow(area, grow, grow);
        } else {
            Geom.grow(area, 1.0, 1.0);
        }
        return area;
    }

    @Override
    public double getDecorationRadius(Figure f) {
        double strokeWidth = AttributeKeys.STROKE_WIDTH.get(f);
        double scaleFactor = strokeWidth > 1.0 ? 1.0 + (strokeWidth - 1.0) / 2.0 : 1.0;
        return this.getDecoratorPathRadius(f) * scaleFactor;
    }

    private GeneralPath getTransformedDecoratorPath(Figure f, Point2D.Double p1, Point2D.Double p2) {
        GeneralPath path = this.getDecoratorPath(f);
        double strokeWidth = AttributeKeys.STROKE_WIDTH.get(f);
        AffineTransform transform = new AffineTransform();
        transform.translate(p1.x, p1.y);
        transform.rotate(Math.atan2(p1.x - p2.x, p2.y - p1.y));
        if (strokeWidth > 1.0) {
            transform.scale(1.0 + (strokeWidth - 1.0) / 2.0, 1.0 + (strokeWidth - 1.0) / 2.0);
        }
        path.transform(transform);
        return path;
    }

    protected void setFilled(boolean b) {
        this.isFilled = b;
    }

    protected void setStroked(boolean b) {
        this.isStroked = b;
    }

    protected void setSolid(boolean b) {
        this.isSolid = b;
    }

    protected abstract GeneralPath getDecoratorPath(Figure var1);

    protected abstract double getDecoratorPathRadius(Figure var1);
}

