/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractConnector;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;

public class ChopRectangleConnector
extends AbstractConnector {
    public ChopRectangleConnector() {
    }

    public ChopRectangleConnector(Figure owner) {
        super(owner);
    }

    @Override
    public Point2D.Double findStart(ConnectionFigure connection) {
        Point2D.Double from;
        Figure startFigure = connection.getStartConnector().getOwner();
        if (connection.getNodeCount() <= 2 || connection.getLiner() != null) {
            if (connection.getEndConnector() == null) {
                from = connection.getEndPoint();
            } else {
                Rectangle2D.Double r1 = this.getConnectorTarget(connection.getEndConnector().getOwner()).getBounds();
                from = new Point2D.Double(r1.x + r1.width / 2.0, r1.y + r1.height / 2.0);
            }
        } else {
            from = connection.getPoint(1);
        }
        return this.chop(startFigure, from);
    }

    @Override
    public Point2D.Double findEnd(ConnectionFigure connection) {
        Point2D.Double from;
        Figure endFigure = connection.getEndConnector().getOwner();
        if (connection.getNodeCount() <= 3 && connection.getStartFigure() == connection.getEndFigure() || connection.getNodeCount() <= 2 || connection.getLiner() != null) {
            if (connection.getStartConnector() == null) {
                from = connection.getStartPoint();
            } else if (connection.getStartFigure() == connection.getEndFigure()) {
                Rectangle2D.Double r1 = this.getConnectorTarget(connection.getStartConnector().getOwner()).getBounds();
                from = new Point2D.Double(r1.x + r1.width / 2.0, r1.y);
            } else {
                Rectangle2D.Double r1 = this.getConnectorTarget(connection.getStartConnector().getOwner()).getBounds();
                from = new Point2D.Double(r1.x + r1.width / 2.0, r1.y + r1.height / 2.0);
            }
        } else {
            from = connection.getPoint(connection.getNodeCount() - 2);
        }
        return this.chop(endFigure, from);
    }

    protected Point2D.Double chop(Figure target, Point2D.Double from) {
        target = this.getConnectorTarget(target);
        Rectangle2D.Double r = target.getBounds();
        if (AttributeKeys.STROKE_COLOR.get(target) != null) {
            double grow;
            switch (AttributeKeys.STROKE_PLACEMENT.get(target)) {
                default: {
                    grow = AttributeKeys.getStrokeTotalWidth(target) / 2.0;
                    break;
                }
                case OUTSIDE: {
                    grow = AttributeKeys.getStrokeTotalWidth(target);
                    break;
                }
                case INSIDE: {
                    grow = 0.0;
                }
            }
            Geom.grow(r, grow, grow);
        }
        return Geom.angleToPoint(r, Geom.pointToAngle(r, from));
    }
}

