/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractFigure;

public class CompositeTransformEdit
extends AbstractUndoableEdit {
    private AbstractFigure owner;
    private AffineTransform tx;
    boolean inProgress;

    public CompositeTransformEdit(AbstractFigure owner, AffineTransform tx) {
        this.owner = owner;
        this.tx = (AffineTransform)tx.clone();
        this.inProgress = true;
    }

    @Override
    public String getPresentationName() {
        return "Figur transformieren";
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit == this) {
            this.end();
            return true;
        }
        if (!this.inProgress) {
            return false;
        }
        anEdit.die();
        return true;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.transform(this.tx);
        this.owner.changed();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        try {
            this.owner.transform(this.tx.createInverse());
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.owner.changed();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void end() {
        this.inProgress = false;
    }

    @Override
    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    @Override
    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }
}

