/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class RoundRectangleRadiusUndoableEdit
extends AbstractUndoableEdit {
    private RoundRectangleFigure owner;
    private Point2D.Double oldArc;
    private Point2D.Double newArc;

    public RoundRectangleRadiusUndoableEdit(RoundRectangleFigure owner, Point2D.Double oldArc, Point2D.Double newArc) {
        this.owner = owner;
        this.oldArc = oldArc;
        this.newArc = newArc;
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
        return labels.getString("attribute.roundRectRadius");
    }

    @Override
    public void redo() throws CannotRedoException {
        this.owner.willChange();
        this.owner.setArc(this.newArc.x, this.newArc.y);
        this.owner.changed();
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.owner.willChange();
        this.owner.setArc(this.oldArc.x, this.oldArc.y);
        this.owner.changed();
        super.undo();
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof RoundRectangleRadiusUndoableEdit) {
            RoundRectangleRadiusUndoableEdit that = (RoundRectangleRadiusUndoableEdit)anEdit;
            if (that.owner == this.owner) {
                this.newArc = that.newArc;
                that.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        if (anEdit instanceof RoundRectangleRadiusUndoableEdit) {
            RoundRectangleRadiusUndoableEdit that = (RoundRectangleRadiusUndoableEdit)anEdit;
            if (that.owner == this.owner) {
                that.oldArc = this.oldArc;
                this.die();
                return true;
            }
        }
        return false;
    }
}

