/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.svg.io.SVGInputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;

public class SVGCreateFromFileTool
extends CreationTool {
    protected FileDialog fileDialog;
    protected JFileChooser fileChooser;
    protected Thread workerThread;
    protected CompositeFigure groupPrototype;
    protected ImageHolderFigure imagePrototype;
    protected boolean useFileDialog;

    public SVGCreateFromFileTool(ImageHolderFigure imagePrototype, CompositeFigure groupPrototype) {
        super(imagePrototype);
        this.groupPrototype = groupPrototype;
        this.imagePrototype = imagePrototype;
    }

    public SVGCreateFromFileTool(ImageHolderFigure imagePrototype, CompositeFigure groupPrototype, Map<AttributeKey, Object> attributes) {
        super(imagePrototype, attributes);
        this.groupPrototype = groupPrototype;
        this.imagePrototype = imagePrototype;
    }

    public void setUseFileDialog(boolean newValue) {
        this.useFileDialog = newValue;
        if (this.useFileDialog) {
            this.fileChooser = null;
        } else {
            this.fileDialog = null;
        }
    }

    public boolean isUseFileDialog() {
        return this.useFileDialog;
    }

    @Override
    public void activate(DrawingEditor editor) {
        File file;
        super.activate(editor);
        if (this.workerThread != null) {
            try {
                this.workerThread.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this.useFileDialog) {
            this.getFileDialog().setVisible(true);
            file = this.getFileDialog().getFile() != null ? new File(this.getFileDialog().getDirectory(), this.getFileDialog().getFile()) : null;
        } else {
            file = this.getFileChooser().showOpenDialog(this.getView().getComponent()) == 0 ? this.getFileChooser().getSelectedFile() : null;
        }
        if (file != null) {
            Worker worker;
            if (file.getName().toLowerCase().endsWith(".svg") || file.getName().toLowerCase().endsWith(".svgz")) {
                this.prototype = (Figure)this.groupPrototype.clone();
                worker = new Worker(){

                    @Override
                    public Object construct() {
                        DefaultDrawing drawing = new DefaultDrawing();
                        try {
                            SVGInputFormat in = file.getName().toLowerCase().endsWith(".svg") ? new SVGInputFormat() : new SVGZInputFormat();
                            in.read(file, drawing);
                        }
                        catch (Throwable t) {
                            return t;
                        }
                        return drawing;
                    }

                    @Override
                    public void finished(Object value) {
                        if (value instanceof Throwable) {
                            Throwable t = (Throwable)value;
                            JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), t.getMessage(), null, 0);
                            SVGCreateFromFileTool.this.getDrawing().remove(SVGCreateFromFileTool.this.createdFigure);
                            SVGCreateFromFileTool.this.fireToolDone();
                        } else {
                            Drawing drawing = (Drawing)value;
                            if (SVGCreateFromFileTool.this.createdFigure == null) {
                                CompositeFigure parent = (CompositeFigure)SVGCreateFromFileTool.this.prototype;
                                for (Figure f : drawing.getChildren()) {
                                    parent.basicAdd(f);
                                }
                            } else {
                                CompositeFigure parent = (CompositeFigure)SVGCreateFromFileTool.this.createdFigure;
                                parent.willChange();
                                for (Figure f : drawing.getChildren()) {
                                    parent.add(f);
                                }
                                parent.changed();
                            }
                        }
                    }
                };
            } else {
                this.prototype = this.imagePrototype;
                final ImageHolderFigure loaderFigure = (ImageHolderFigure)this.prototype.clone();
                worker = new Worker(){

                    @Override
                    public Object construct() {
                        try {
                            loaderFigure.loadImage(file);
                        }
                        catch (Throwable t) {
                            return t;
                        }
                        return null;
                    }

                    @Override
                    public void finished(Object value) {
                        if (value instanceof Throwable) {
                            Throwable t = (Throwable)value;
                            JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), t.getMessage(), null, 0);
                            SVGCreateFromFileTool.this.getDrawing().remove(SVGCreateFromFileTool.this.createdFigure);
                            SVGCreateFromFileTool.this.fireToolDone();
                        } else {
                            try {
                                if (SVGCreateFromFileTool.this.createdFigure == null) {
                                    ((ImageHolderFigure)SVGCreateFromFileTool.this.prototype).setImage(loaderFigure.getImageData(), loaderFigure.getBufferedImage());
                                } else {
                                    ((ImageHolderFigure)SVGCreateFromFileTool.this.createdFigure).setImage(loaderFigure.getImageData(), loaderFigure.getBufferedImage());
                                }
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), ex.getMessage(), null, 0);
                            }
                        }
                    }
                };
            }
            this.workerThread = new Thread(worker);
            this.workerThread.start();
        } else if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    @Override
    protected Figure createFigure() {
        if (this.prototype instanceof CompositeFigure) {
            return (Figure)this.prototype.clone();
        }
        return super.createFigure();
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    private FileDialog getFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(new Frame());
        }
        return this.fileDialog;
    }
}

