/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGRectRadiusHandle;

public class SVGRectFigure
extends SVGAttributedFigure
implements SVGFigure {
    private static final double acv;
    private RoundRectangle2D.Double roundrect;
    private transient Shape cachedTransformedShape;
    private transient Shape cachedHitShape;

    public SVGRectFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public SVGRectFigure(double x, double y, double width, double height) {
        this(x, y, width, height, 0.0, 0.0);
    }

    public SVGRectFigure(double x, double y, double width, double height, double rx, double ry) {
        this.roundrect = new RoundRectangle2D.Double(x, y, width, height, rx, ry);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        if (this.getArcHeight() == 0.0 && this.getArcWidth() == 0.0) {
            g.fill(this.roundrect.getBounds2D());
        } else {
            g.fill(this.roundrect);
        }
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        if (this.roundrect.archeight == 0.0 && this.roundrect.arcwidth == 0.0) {
            g.draw(this.roundrect.getBounds2D());
        } else {
            GeneralPath p = new GeneralPath();
            double aw = this.roundrect.arcwidth / 2.0;
            double ah = this.roundrect.archeight / 2.0;
            p.moveTo((float)(this.roundrect.x + aw), (float)this.roundrect.y);
            p.lineTo((float)(this.roundrect.x + this.roundrect.width - aw), (float)this.roundrect.y);
            p.curveTo((float)(this.roundrect.x + this.roundrect.width - aw * acv), (float)this.roundrect.y, (float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + ah * acv), (float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + ah));
            p.lineTo((float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + this.roundrect.height - ah));
            p.curveTo((float)(this.roundrect.x + this.roundrect.width), (float)(this.roundrect.y + this.roundrect.height - ah * acv), (float)(this.roundrect.x + this.roundrect.width - aw * acv), (float)(this.roundrect.y + this.roundrect.height), (float)(this.roundrect.x + this.roundrect.width - aw), (float)(this.roundrect.y + this.roundrect.height));
            p.lineTo((float)(this.roundrect.x + aw), (float)(this.roundrect.y + this.roundrect.height));
            p.curveTo((float)(this.roundrect.x + aw * acv), (float)(this.roundrect.y + this.roundrect.height), (float)this.roundrect.x, (float)(this.roundrect.y + this.roundrect.height - ah * acv), (float)this.roundrect.x, (float)(this.roundrect.y + this.roundrect.height - ah));
            p.lineTo((float)this.roundrect.x, (float)(this.roundrect.y + ah));
            p.curveTo((float)this.roundrect.x, (float)(this.roundrect.y + ah * acv), (float)(this.roundrect.x + aw * acv), (float)this.roundrect.y, (float)(this.roundrect.x + aw), (float)this.roundrect.y);
            p.closePath();
            g.draw(p);
        }
    }

    public double getX() {
        return this.roundrect.x;
    }

    public double getY() {
        return this.roundrect.y;
    }

    public double getWidth() {
        return this.roundrect.width;
    }

    public double getHeight() {
        return this.roundrect.height;
    }

    public double getArcWidth() {
        return this.roundrect.arcwidth / 2.0;
    }

    public double getArcHeight() {
        return this.roundrect.archeight / 2.0;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.roundrect.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r;
        Rectangle2D rx = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double double_ = r = rx instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
        if (SVGAttributeKeys.TRANSFORM.get(this) == null) {
            double g = SVGAttributeKeys.getPerpendicularHitGrowth(this) * 2.0 + 1.0;
            Geom.grow(r, g, g);
        } else {
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            if ((Integer)SVGAttributeKeys.STROKE_JOIN.get(this) == 0) {
                width *= ((Double)SVGAttributeKeys.STROKE_MITER_LIMIT.get(this)).doubleValue();
            }
            if ((Integer)SVGAttributeKeys.STROKE_CAP.get(this) != 0) {
                width += strokeTotalWidth * 2.0;
            }
            Geom.grow(r, width += 1.0, width);
        }
        return r;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return this.getHitShape().contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.invalidateTransformedShape();
        this.roundrect.x = Math.min(anchor.x, lead.x);
        this.roundrect.y = Math.min(anchor.y, lead.y);
        this.roundrect.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.roundrect.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
        this.invalidate();
    }

    private void invalidateTransformedShape() {
        this.cachedTransformedShape = null;
        this.cachedHitShape = null;
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = this.getArcHeight() == 0.0 || this.getArcWidth() == 0.0 ? this.roundrect.getBounds2D() : (Shape)this.roundrect.clone();
            if (SVGAttributeKeys.TRANSFORM.get(this) != null) {
                this.cachedTransformedShape = ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this)).createTransformedShape(this.cachedTransformedShape);
            }
        }
        return this.cachedTransformedShape;
    }

    private Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = SVGAttributeKeys.FILL_COLOR.get(this) != null || SVGAttributeKeys.FILL_GRADIENT.get(this) != null ? new GrowStroke((float)SVGAttributeKeys.getStrokeTotalWidth(this) / 2.0f, (float)SVGAttributeKeys.getStrokeTotalMiterLimit(this)).createStrokedShape(this.getTransformedShape()) : SVGAttributeKeys.getHitStroke(this).createStrokedShape(this.getTransformedShape());
        }
        return this.cachedHitShape;
    }

    @Override
    public void transform(AffineTransform tx) {
        this.invalidateTransformedShape();
        if (SVGAttributeKeys.TRANSFORM.get(this) != null || (tx.getType() & 1) != tx.getType()) {
            if (SVGAttributeKeys.TRANSFORM.get(this) == null) {
                SVGAttributeKeys.TRANSFORM.basicSet(this, (AffineTransform)tx.clone());
            } else {
                AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                SVGAttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            Gradient g;
            Point2D.Double anchor = this.getStartPoint();
            Point2D.Double lead = this.getEndPoint();
            this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
            if (SVGAttributeKeys.FILL_GRADIENT.get(this) != null && !SVGAttributeKeys.FILL_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.FILL_GRADIENT.basicSet(this, g);
            }
            if (SVGAttributeKeys.STROKE_GRADIENT.get(this) != null && !SVGAttributeKeys.STROKE_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.STROKE_GRADIENT.basicSet(this, g);
            }
        }
    }

    public void setArc(double w, double h) {
        this.roundrect.arcwidth = Math.max(0.0, Math.min(this.roundrect.width, w * 2.0));
        this.roundrect.archeight = Math.max(0.0, Math.min(this.roundrect.height, h * 2.0));
    }

    public void setArc(Dimension2DDouble arc) {
        this.roundrect.arcwidth = Math.max(0.0, Math.min(this.roundrect.width, arc.width * 2.0));
        this.roundrect.archeight = Math.max(0.0, Math.min(this.roundrect.height, arc.height * 2.0));
    }

    public Dimension2DDouble getArc() {
        return new Dimension2DDouble(this.roundrect.arcwidth / 2.0, this.roundrect.archeight / 2.0);
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.invalidateTransformedShape();
        Object[] restoreData = (Object[])geometry;
        this.roundrect = (RoundRectangle2D.Double)((RoundRectangle2D.Double)restoreData[0]).clone();
        SVGAttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[1]);
        SVGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.roundrect.clone(), SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
                handles.add(new SVGRectRadiusHandle(this));
                handles.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public SVGRectFigure clone() {
        SVGRectFigure that = (SVGRectFigure)super.clone();
        that.roundrect = (RoundRectangle2D.Double)this.roundrect.clone();
        that.cachedTransformedShape = null;
        that.cachedHitShape = null;
        return that;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateTransformedShape();
    }

    static {
        double angle = 0.7853981633974483;
        double a = 1.0 - Math.cos(angle);
        double b = Math.tan(angle);
        double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
        double cv = 1.3333333333333333 * a * b / c;
        acv = 1.0 - cv;
    }
}

