/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.SelectionComponentRepainter;
import org.jhotdraw.gui.FigureAttributeEditorHandler;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionComponentDisplayer;
import org.jhotdraw.samples.svg.gui.SelectionOpacityIcon;
import org.jhotdraw.text.ColorFormatter;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class StrokeToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;

    public StrokeToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString("stroke.toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(newValue);
        if (newValue != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                HashMap<AttributeKey, Object> defaultAttributes = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.STROKE_GRADIENT.set(defaultAttributes, null);
                JPopupButton btn = ButtonFactory.createSelectionColorButton(this.editor, SVGAttributeKeys.STROKE_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.strokeColor", labels, defaultAttributes, new Rectangle(3, 3, 10, 10));
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.setAction(null, null);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.anchor = 23;
                p.add((Component)btn, gbc);
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacityPopupButton.add(opacitySlider);
                labels.configureToolBarButton(opacityPopupButton, "attribute.strokeOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.STROKE_OPACITY, null, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, this.getClass().getResource(labels.getString("attribute.strokeOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                opacityPopupButton.setPopupAnchor(4);
                new SelectionComponentRepainter(this.editor, opacityPopupButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.anchor = 23;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)opacityPopupButton, gbc);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_OPACITY, opacitySlider, this.editor);
                JPopupButton strokeWidthPopupButton = new JPopupButton();
                JAttributeSlider strokeWidthSlider = new JAttributeSlider(1, 0, 50, 1);
                strokeWidthSlider.setUI((SliderUI)PaletteSliderUI.createUI(strokeWidthSlider));
                strokeWidthPopupButton.add(strokeWidthSlider);
                labels.configureToolBarButton(strokeWidthPopupButton, "attribute.strokeWidth");
                strokeWidthPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(strokeWidthPopupButton));
                gbc = new GridBagConstraints();
                gbc.anchor = 23;
                gbc.gridx = 0;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)strokeWidthPopupButton, gbc);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_WIDTH, strokeWidthSlider, this.editor);
                btn = ButtonFactory.createStrokeJoinButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.anchor = 23;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 3, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createStrokeCapButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.anchor = 23;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createStrokeDashesButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridwidth = 0;
                gbc.anchor = 23;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
                break;
            }
            case 2: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                HashMap<AttributeKey, Object> defaultAttributes = new HashMap<AttributeKey, Object>();
                SVGAttributeKeys.STROKE_GRADIENT.set(defaultAttributes, null);
                JAttributeTextField colorField = new JAttributeTextField();
                colorField.setColumns(7);
                colorField.setToolTipText(labels.getString("attribute.strokeColor.toolTipText"));
                colorField.putClientProperty("Palette.Component.segmentPosition", "first");
                colorField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(colorField));
                colorField.setFormatterFactory(ColorFormatter.createFormatterFactory());
                colorField.setHorizontalAlignment(2);
                new FigureAttributeEditorHandler(SVGAttributeKeys.STROKE_COLOR, defaultAttributes, colorField, this.editor, true);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridwidth = 3;
                gbc.fill = 2;
                gbc.anchor = 23;
                p.add(colorField, gbc);
                JPopupButton btn = ButtonFactory.createSelectionColorButton(this.editor, SVGAttributeKeys.STROKE_COLOR, ButtonFactory.HSV_COLORS, 12, "attribute.strokeColor", labels, defaultAttributes, new Rectangle(3, 3, 10, 10));
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.setAction(null, null);
                gbc = new GridBagConstraints();
                gbc.gridx = 3;
                gbc.anchor = 23;
                p.add((Component)btn, gbc);
                JAttributeTextField opacityField = new JAttributeTextField();
                opacityField.setColumns(3);
                opacityField.setToolTipText(labels.getString("attribute.strokeOpacity.toolTipText"));
                opacityField.setHorizontalAlignment(4);
                opacityField.putClientProperty("Palette.Component.segmentPosition", "first");
                opacityField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(opacityField));
                opacityField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1.0, 100.0));
                opacityField.setHorizontalAlignment(2);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_OPACITY, opacityField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.fill = 2;
                gbc.anchor = 23;
                p.add(opacityField, gbc);
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacityPopupButton.add(opacitySlider);
                labels.configureToolBarButton(opacityPopupButton, "attribute.strokeOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.STROKE_OPACITY, null, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, this.getClass().getResource(labels.getString("attribute.strokeOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                opacityPopupButton.setPopupAnchor(4);
                new SelectionComponentRepainter(this.editor, opacityPopupButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.anchor = 23;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)opacityPopupButton, gbc);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_OPACITY, opacitySlider, this.editor);
                JAttributeTextField strokeWidthField = new JAttributeTextField();
                strokeWidthField.setColumns(2);
                strokeWidthField.setToolTipText(labels.getString("attribute.strokeWidth.toolTipText"));
                strokeWidthField.setHorizontalAlignment(2);
                strokeWidthField.putClientProperty("Palette.Component.segmentPosition", "first");
                strokeWidthField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(strokeWidthField));
                strokeWidthField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 100.0, 1.0));
                new FigureAttributeEditorHandler(SVGAttributeKeys.STROKE_WIDTH, strokeWidthField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.fill = 1;
                p.add(strokeWidthField, gbc);
                JPopupButton strokeWidthPopupButton = new JPopupButton();
                JAttributeSlider strokeWidthSlider = new JAttributeSlider(1, 0, 50, 1);
                strokeWidthSlider.setUI((SliderUI)PaletteSliderUI.createUI(strokeWidthSlider));
                strokeWidthPopupButton.add(strokeWidthSlider);
                labels.configureToolBarButton(strokeWidthPopupButton, "attribute.strokeWidth");
                strokeWidthPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(strokeWidthPopupButton));
                gbc = new GridBagConstraints();
                gbc.anchor = 23;
                gbc.gridx = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)strokeWidthPopupButton, gbc);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.STROKE_WIDTH, strokeWidthSlider, this.editor);
                btn = ButtonFactory.createStrokeJoinButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.anchor = 23;
                gbc.gridx = 4;
                gbc.gridy = 0;
                gbc.gridwidth = 2;
                gbc.insets = new Insets(0, 3, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createStrokeCapButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.anchor = 23;
                gbc.gridx = 4;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
                JAttributeTextField dashOffsetField = new JAttributeTextField();
                dashOffsetField.setColumns(1);
                dashOffsetField.setToolTipText(labels.getString("attribute.strokeDashPhase.toolTipText"));
                dashOffsetField.setHorizontalAlignment(2);
                dashOffsetField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(dashOffsetField));
                dashOffsetField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(-1000.0, 1000.0, 1.0));
                new FigureAttributeEditorHandler(SVGAttributeKeys.STROKE_DASH_PHASE, dashOffsetField, this.editor);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 3, 0, 0);
                gbc.fill = 1;
                gbc.gridwidth = 2;
                p.add(dashOffsetField, gbc);
                btn = ButtonFactory.createStrokeDashesButton(this.editor, labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridwidth = 0;
                gbc.anchor = 23;
                gbc.gridx = 4;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
            }
        }
        return p;
    }

    @Override
    protected String getID() {
        return "stroke";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
        this.setOpaque(false);
    }
}

