/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.alert;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.google.Utils;

public class GoogleMail {
    private static final Log log = LogFactory.getLog(GoogleMail.class);

    private GoogleMail() {
    }

    private static MimeMessage createEmail(String to, String cc, String from, String subject, String bodyText) throws MessagingException {
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage email = new MimeMessage(session);
        InternetAddress tAddress = new InternetAddress(to);
        InternetAddress cAddress = org.yccheok.jstock.gui.Utils.isNullOrEmpty(cc) ? null : new InternetAddress(cc);
        InternetAddress fAddress = new InternetAddress(from);
        email.setFrom((Address)fAddress);
        if (cAddress != null) {
            email.addRecipient(Message.RecipientType.CC, (Address)cAddress);
        }
        email.addRecipient(Message.RecipientType.TO, (Address)tAddress);
        email.setSubject(subject);
        email.setText(bodyText);
        return email;
    }

    private static Message createMessageWithEmail(MimeMessage email) throws MessagingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        email.writeTo((OutputStream)baos);
        String encodedEmail = Base64.getUrlEncoder().encodeToString(baos.toByteArray());
        Message message = new Message();
        message.setRaw(encodedEmail);
        return message;
    }

    public static void Send(Gmail service, String recipientEmail, String ccEmail, String fromEmail, String title, String message) throws IOException, MessagingException {
        Message m = GoogleMail.createMessageWithEmail(GoogleMail.createEmail(recipientEmail, ccEmail, fromEmail, title, message));
        service.users().messages().send("me", m).execute();
    }

    public static void Send(String ccEmail, String title, String message) throws Exception {
        Pair<Credential, String> credentialEx = Utils.authorizeGmailOffline();
        Credential credential = (Credential)credentialEx.first;
        Gmail service = Utils.getGmail(credential);
        String recipientEmail = (String)credentialEx.second;
        String fromEmail = (String)credentialEx.second;
        GoogleMail.Send(service, recipientEmail, ccEmail, fromEmail, title, message);
    }
}

