/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.engine.iex.batch.Quote;
import org.yccheok.jstock.engine.iex.batch.QuoteResponse;
import retrofit2.Call;

public class IEXStockServer
implements StockServer {
    private static final int IEX_SYMBOLS_LIMIT = 96;
    private static final String TAG = "IEXStockServer";
    private static final Log log = LogFactory.getLog(IEXStockServer.class);

    @Override
    public Stock getStock(Code code) {
        return this._getStock(code);
    }

    @Override
    public List<Stock> getStocks(List<Code> codes) {
        return this._getStocks(codes);
    }

    private List<Stock> getStocks(String codes) {
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        try {
            Call<Map<String, QuoteResponse>> call = Utils.getIEXApi().batchMultipleQuote(codes, Utils.getIEXToken());
            Map batchMultipleQuoteResponse = (Map)call.execute().body();
            for (Map.Entry entry : batchMultipleQuoteResponse.entrySet()) {
                String iexStockCode = (String)entry.getKey();
                Quote quote = ((QuoteResponse)entry.getValue()).getQuote();
                Code c = Code.newInstance(iexStockCode);
                Symbol symbol = false == org.yccheok.jstock.gui.Utils.isNullOrEmpty(quote.getCompanyName()) ? Symbol.newInstance(quote.getCompanyName()) : Symbol.newInstance(c.toString());
                String name = symbol.toString();
                Currency currency = Currency.valueOf("USD");
                Board board = Board.Unknown;
                Industry industry = Industry.Unknown;
                double prevPrice = quote.getPreviousClose();
                double openPrice = quote.getOpen();
                double lastPrice = quote.getLatestPrice();
                double highPrice = quote.getHigh();
                double lowPrice = quote.getLow();
                long volume = quote.getLatestVolume();
                double changePrice = quote.getChange();
                double changePricePercentage = quote.getChangePercent() * 100.0;
                int lastVolume = 0;
                double buyPrice = quote.getIexBidPrice();
                int buyQuantity = (int)quote.getIexBidSize();
                double sellPrice = quote.getIexAskPrice();
                int sellQuantity = (int)quote.getIexAskSize();
                long timestamp = quote.getLatestUpdate();
                Stock stock = new Stock(c, symbol, name, currency, board, industry, prevPrice, openPrice, lastPrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, lastVolume, buyPrice, buyQuantity, sellPrice, sellQuantity, timestamp);
                stocks.add(stock);
            }
        }
        catch (Exception | IncompatibleClassChangeError | OutOfMemoryError e) {
            log.error(null, e);
        }
        return stocks;
    }

    private List<Stock> _getStocks(List<Code> codes) {
        if (codes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        HashMap<Code, Code> iexFormatCodes = new HashMap<Code, Code>();
        for (Code code : codes) {
            iexFormatCodes.put(code, Utils.toIEXFormatCode(code));
        }
        int time = codes.size() / 96;
        int remainder = codes.size() % 96;
        for (int i = 0; i < time; ++i) {
            List<Stock> bestStocks;
            int start = i * 96;
            int end = start + 96;
            StringBuilder codeBuilder = new StringBuilder();
            for (int j = start; j < end; ++j) {
                Code iexFormatCode = (Code)iexFormatCodes.get(codes.get(j));
                assert (iexFormatCode != null);
                String iexFormatCodeString = iexFormatCode.toString();
                codeBuilder.append(iexFormatCodeString).append(",");
            }
            String _code = codeBuilder.toString();
            if (_code.endsWith(",")) {
                _code = _code.substring(0, _code.length() - 1);
            }
            if (_code.isEmpty() || (bestStocks = this.getStocks(_code)) == null) continue;
            stocks.addAll(bestStocks);
        }
        int start = codes.size() - remainder;
        int end = start + remainder;
        StringBuilder codeBuilder = new StringBuilder();
        for (int i = start; i < end; ++i) {
            Code iexFormatCode = (Code)iexFormatCodes.get(codes.get(i));
            assert (iexFormatCode != null);
            String iexFormatCodeString = iexFormatCode.toString();
            codeBuilder.append(iexFormatCodeString).append(",");
        }
        String _code = codeBuilder.toString();
        if (_code.endsWith(",")) {
            _code = _code.substring(0, _code.length() - 1);
        }
        if (_code.isEmpty()) {
            return IEXStockServer.normalize(codes, iexFormatCodes, stocks);
        }
        List<Stock> bestStocks = this.getStocks(_code);
        if (bestStocks != null) {
            stocks.addAll(bestStocks);
        }
        return IEXStockServer.normalize(codes, iexFormatCodes, stocks);
    }

    private static List<Stock> normalize(List<Code> codes, Map<Code, Code> iexFormatCodes, List<Stock> stocks) {
        HashMap<Code, Stock> iexFormatCodeToStocks = new HashMap<Code, Stock>();
        for (Stock stock : stocks) {
            iexFormatCodeToStocks.put(stock.code, stock);
        }
        ArrayList<Stock> normalizedStocks = new ArrayList<Stock>();
        for (Code code : codes) {
            Code iexFormatCode = iexFormatCodes.get(code);
            assert (iexFormatCode != null);
            Stock normalizedStock = (Stock)iexFormatCodeToStocks.get(iexFormatCode);
            if (normalizedStock == null) continue;
            if (normalizedStock.code.equals(code)) {
                normalizedStocks.add(normalizedStock);
                continue;
            }
            normalizedStock = normalizedStock.deriveStock(code);
            normalizedStocks.add(normalizedStock);
        }
        return normalizedStocks;
    }

    private Stock _getStock(Code code) {
        ArrayList<Code> codes = new ArrayList<Code>();
        codes.add(code);
        List<Stock> stocks = this._getStocks(codes);
        if (!stocks.isEmpty()) {
            return stocks.get(0);
        }
        return null;
    }
}

