/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.Market;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.Subject;

public class RealTimeIndexMonitor
extends Subject<RealTimeIndexMonitor, List<Market>> {
    private final Map<Code, Index> indexMapping = new ConcurrentHashMap<Code, Index>();
    private final RealTimeStockMonitor realTimeStockMonitor;

    public RealTimeIndexMonitor(int maxThread, int maxBucketSize, long delay) {
        this.realTimeStockMonitor = new RealTimeStockMonitor(maxThread, maxBucketSize, delay);
        this.realTimeStockMonitor.attach(this.getRealTimeStockMonitorObserver());
    }

    private Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> getRealTimeStockMonitorObserver() {
        return new Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result>(){

            @Override
            public void update(RealTimeStockMonitor subject, RealTimeStockMonitor.Result result) {
                ArrayList<Market> markets = new ArrayList<Market>();
                for (Stock stock : result.stocks) {
                    Index index = (Index)((Object)RealTimeIndexMonitor.this.indexMapping.get(stock.code));
                    if (index == null) continue;
                    markets.add(Market.newInstance(stock, index));
                }
                if (!markets.isEmpty()) {
                    RealTimeIndexMonitor.this.notify(RealTimeIndexMonitor.this, markets);
                }
            }
        };
    }

    public synchronized boolean addIndex(Index index) {
        if (this.realTimeStockMonitor.addStockCode(index.code)) {
            this.indexMapping.put(index.code, index);
            return true;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        return this.realTimeStockMonitor.isEmpty();
    }

    public synchronized boolean clearIndices() {
        this.indexMapping.clear();
        return this.realTimeStockMonitor.clearStockCodes();
    }

    public synchronized boolean removeIndex(Index index) {
        this.indexMapping.remove(index.code);
        return this.realTimeStockMonitor.removeStockCode(index.code);
    }

    public synchronized void resume() {
        this.realTimeStockMonitor.resume();
    }

    public synchronized void suspend() {
        this.realTimeStockMonitor.suspend();
    }

    public synchronized void startNewThreadsIfNecessary() {
        this.realTimeStockMonitor.startNewThreadsIfNecessary();
    }

    public synchronized void rebuild() {
        this.realTimeStockMonitor.rebuild();
    }

    public synchronized void stop() {
        this.realTimeStockMonitor.stop();
    }

    public synchronized void refresh() {
        this.realTimeStockMonitor.refresh();
    }

    public synchronized void setDelay(int delay) {
        this.realTimeStockMonitor.setDelay(delay);
    }
}

