/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.google;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.oauth2.model.Userinfoplus;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.google.SimpleSwingBrowser;
import org.yccheok.jstock.google.Utils;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class MyAuthorizationCodeInstalledApp {
    private static final Log log = LogFactory.getLog(MyAuthorizationCodeInstalledApp.class);
    private static final String CODE = "org.yccheok.jstock.google.MyAuthorizationCodeInstalledApp";
    private SimpleSwingBrowser browser;
    private String redirectUri;
    private final AuthorizationCodeFlow flow;
    private final VerificationCodeReceiver receiver;

    public MyAuthorizationCodeInstalledApp(AuthorizationCodeFlow flow, VerificationCodeReceiver receiver) {
        this.flow = (AuthorizationCodeFlow)Preconditions.checkNotNull((Object)flow);
        this.receiver = (VerificationCodeReceiver)Preconditions.checkNotNull((Object)receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Pair<Credential, String>, Boolean> authorize(String userId) throws IOException {
        try {
            Credential credential = this.flow.loadCredential(userId);
            if (credential != null && credential.getRefreshToken() != null) {
                boolean success = false;
                if (credential.getExpiresInSeconds() <= 60L) {
                    if (credential.refreshToken()) {
                        success = true;
                    }
                } else {
                    success = true;
                }
                if (success) {
                    Object userinfoplus;
                    FileDataStoreFactory fileDataStoreFactory = (FileDataStoreFactory)this.flow.getCredentialDataStore().getDataStoreFactory();
                    String email = Utils.loadEmail(fileDataStoreFactory.getDataDirectory());
                    if (email == null) {
                        userinfoplus = Utils.getUserInfo(credential);
                        email = userinfoplus.getEmail();
                    }
                    userinfoplus = new Pair<Pair<Credential, String>, Boolean>(new Pair<Credential, String>(credential, email), true);
                    return userinfoplus;
                }
            }
            this.redirectUri = this.receiver.getRedirectUri();
            AuthorizationCodeRequestUrl authorizationUrl = this.flow.newAuthorizationUrl().setRedirectUri(this.redirectUri);
            this.onAuthorization(authorizationUrl);
            String code = this.receiver.waitForCode();
            if (code.equals(CODE)) {
                Pair<Pair<Credential, String>, Boolean> email = null;
                return email;
            }
            TokenResponse response = this.flow.newTokenRequest(code).setRedirectUri(this.redirectUri).execute();
            credential = this.flow.createAndStoreCredential(response, userId);
            Userinfoplus userinfoplus = Utils.getUserInfo(credential);
            String email = userinfoplus.getEmail();
            FileDataStoreFactory fileDataStoreFactory = (FileDataStoreFactory)this.flow.getCredentialDataStore().getDataStoreFactory();
            Utils.saveEmail(fileDataStoreFactory.getDataDirectory(), email);
            Pair<Pair<Credential, String>, Boolean> pair = new Pair<Pair<Credential, String>, Boolean>(new Pair<Credential, String>(credential, email), false);
            return pair;
        }
        finally {
            this.receiver.stop();
            SimpleSwingBrowser _browser = this.browser;
            if (_browser != null) {
                _browser.setVisible(false);
                try {
                    _browser.dispose();
                }
                catch (Exception ex) {
                    this.performRedirectUri();
                    log.error(null, (Throwable)ex);
                }
                this.browser = null;
            }
        }
    }

    protected void onAuthorization(AuthorizationCodeRequestUrl authorizationUrl) throws IOException {
        final String url = authorizationUrl.build();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!MyAuthorizationCodeInstalledApp.this.launchJavaFxBrowser(url)) {
                    MyAuthorizationCodeInstalledApp.this.launchDesktopBrowser(url);
                }
            }
        });
    }

    private void launchDesktopBrowser(String url) {
        try {
            if (GUIUtils.openURLInBrowser(url)) {
                JOptionPane.showMessageDialog(null, MessagesBundle.getString("info_message_press_ok_after_browser_is_closed"), GUIBundle.getString("MainFrame_Application_Title"), 1);
            } else {
                JOptionPane.showMessageDialog(null, MessagesBundle.getString("error_message_fail_to_launch_browser"), MessagesBundle.getString("error_title_fail_to_launch_browser"), 0);
            }
        }
        finally {
            this.performRedirectUri();
        }
    }

    private boolean launchJavaFxBrowser(String url) {
        try {
            SimpleSwingBrowser _browser = new SimpleSwingBrowser();
            _browser.setDefaultCloseOperation(0);
            _browser.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent evt) {
                    MyAuthorizationCodeInstalledApp.this.performRedirectUri();
                }

                @Override
                public void windowClosing(WindowEvent evt) {
                    SimpleSwingBrowser _browser = MyAuthorizationCodeInstalledApp.this.browser;
                    if (_browser != null) {
                        _browser.setVisible(false);
                        try {
                            _browser.dispose();
                        }
                        catch (Exception ex) {
                            MyAuthorizationCodeInstalledApp.this.performRedirectUri();
                            log.error(null, (Throwable)ex);
                        }
                        MyAuthorizationCodeInstalledApp.this.browser = null;
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent evt) {
                }

                @Override
                public void windowIconified(WindowEvent evt) {
                }
            });
            this.browser = _browser;
            _browser.loadURL(url);
            _browser.setVisible(true);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return false;
        }
        return true;
    }

    private void performRedirectUri() {
        String uri = this.redirectUri;
        if (uri == null) {
            return;
        }
        this.redirectUri = null;
        final String url = uri + "?code=" + CODE;
        new Thread(new Runnable(){

            @Override
            public void run() {
                org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(url);
            }
        }).start();
    }

    public final AuthorizationCodeFlow getFlow() {
        return this.flow;
    }

    public final VerificationCodeReceiver getReceiver() {
        return this.receiver;
    }
}

